package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.sfa.common.core.annotation.Excel;
import com.sfa.common.core.web.domain.BaseDo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 王小卤后台数据对象 ec_ba_store_daily_data
 *
 * @author admin
 * @date 2024-12-19
 */
@TableName(value ="ec_ba_store_daily_data")
@Data
public class EcBaStoreDailyData extends BaseDo
{
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    /** id标识 */
    @TableId(type = IdType.AUTO)
    private Long ebtId;

    /** 年份 */
    @Excel(name = "年份")
    private Long year;

    /** 月份 */
    @Excel(name = "月份")
    private Long month;

    /** 日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date date;

    /** 平台id */
    @Excel(name = "平台id")
    private Long platformId;

    /** 1 天猫; 2 抖音; 3 拼多多; 4 京东; 5 私域; 6 分销; 7 线下; 8 样品; 9 团购; 10 其他; */
    @Excel(name = "1 天猫; 2 抖音; 3 拼多多; 4 京东; 5 私域; 6 分销; 7 线下; 8 样品; 9 团购; 10 其他;")
    private String platform;

    /** 取数平台：生意参谋、拼多多后台、抖音罗盘 */
    @Excel(name = "取数平台：生意参谋、拼多多后台、抖音罗盘")
    private String dataPlatform;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String storeCode;

    /** 店铺名称 */
    @Excel(name = "店铺名称")
    private String storeName;

    /** 成交总额-支付金额 */
    @Excel(name = "成交总额-支付金额")
    private BigDecimal gmv;

    /** 净成交总额-支付金额-退款 */
    @Excel(name = "净成交总额-支付金额-退款")
    private BigDecimal netGmv;

    /** 投资回报率，单位% */
    @Excel(name = "投资回报率，单位%")
    private BigDecimal roi;

    /** 推广花费（包含每日额外平均） */
    @Excel(name = "推广花费", readConverterExp = "包=含每日额外平均")
    private BigDecimal promotionCost;

    /** 推广花费-每日额外平均，淘宝天猫有 */
    @Excel(name = "推广花费-每日额外平均，淘宝天猫有")
    private BigDecimal promotionCostExtra;

    /** 推广产出-推广总交易额 */
    @Excel(name = "推广产出-推广总交易额")
    private BigDecimal promotionOutput;

    /** 浏览量 */
    @Excel(name = "浏览量")
    private Long pv;

    /** 点击人数-unique visitor(访客) */
    @Excel(name = "点击人数-unique visitor(访客)")
    private Long uv;

    /** 成交人数-支付买家 */
    @Excel(name = "成交人数-支付买家")
    private Long transactionsNum;

    /** 成交转化率Conversion Rate-支付转化 */
    @Excel(name = "成交转化率Conversion Rate-支付转化")
    private BigDecimal cvr;

    /** 退款金额 */
    @Excel(name = "退款金额")
    private BigDecimal refundAmount;

    /** 退款率:退款金额/gmv */
    @Excel(name = "退款率:退款金额/gmv")
    private BigDecimal refundRate;

    /** 客单价Average Transaction Value */
    @Excel(name = "客单价Average Transaction Value")
    private BigDecimal atv;

    /** 批次号 */
    @Excel(name = "批次号")
    private String batchNo;

    /** 是否删除标志0未删除1已删除 */
    private String delFlag;

    /** 创建人UserID */
    @Excel(name = "创建人UserID")
    private Long createUserId;

    /** 修改人UserID */
    @Excel(name = "修改人UserID")
    private Long updateUserId;
}
