package com.link.bi.controller.query;

import com.link.bi.pojo.request.OppoSycmVo;
import com.link.bi.pojo.response.OppoSycmStoreDto;
import com.link.bi.pojo.response.OppoSycmStoreInfoDto;
import com.link.bi.service.IOppoSycmStoreService;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 电商竞品-生意参谋数据（天猫）Controller
 *
 * @author admin
 * @date 2024-12-20
 */
@RestController
@RequestMapping("/oppo/sycm/store")
public class OppoSycmStoreQueryController extends BaseController {
    @Autowired
    private IOppoSycmStoreService oppoSycmStoreService;

    /**
     * 查询电商竞品-生意参谋数据（天猫）列表
     */
    @RequiresPermissions("bi:competitor:list")
    @GetMapping("/list")
    public List<List<OppoSycmStoreDto>> list(OppoSycmVo oppoSycmVo) {
        return oppoSycmStoreService.selectOppoSycmStoreBi(oppoSycmVo);
    }

    /**
     * 查询电商竞品-生意参谋数据（天猫）列表
     */
    @RequiresPermissions("bi:competitor:list")
    @GetMapping("/all")
    public List<OppoSycmStoreInfoDto> info() {
        return oppoSycmStoreService.selectOppoSycmStoreInfoBi();
    }

}
