package com.link.bi.service.impl;


import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.bi.domain.entity.FinanceBaseProduct;
import com.link.bi.domain.mapper.FinanceBaseProductMapper;
import com.link.bi.pojo.request.FinanceSelectCommonVo;
import com.link.bi.pojo.response.FinanceBaseProductListDto;
import com.link.bi.service.FinanceBaseProductService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;


/**
 * 旺店通订单Service业务层处理
 *
 * @author lvbencai
 * @date 2025年01月07日17:00:16
 */
@DS("bi")
@Slf4j
@Service
public class FinanceBaseProductServiceImpl extends ServiceImpl<FinanceBaseProductMapper, FinanceBaseProduct> implements FinanceBaseProductService {


    @Override
    public Map<String, FinanceBaseProduct> selectBaseProduct() {
        // 查询所有商品
        List<FinanceBaseProduct> list = list();
        // 以料号为key，商品对象为value，放入map中
        Map<String, FinanceBaseProduct> map = list.stream()
                .collect(HashMap::new, (k, v) -> k.put(v.getPrdCode(), v), HashMap::putAll);
        return map;
    }

    @Override
    public boolean saveProduct(FinanceBaseProduct product) {
        return this.save(product);
    }


    @Override
    public boolean removeProductById(Integer id) {
        return this.removeById(id);
    }


    @Override
    public boolean updateProduct(FinanceBaseProduct product) {
        return this.updateById(product);
    }


    @Override
    public FinanceBaseProduct getProductById(Integer id) {
        return this.getById(id);
    }


    @Override
    public IPage<FinanceBaseProduct> pageProduct(IPage<FinanceBaseProduct> page, Wrapper<FinanceBaseProduct> wrapper) {
        return this.page(page, wrapper);
    }

    @Override
    public List<FinanceBaseProductListDto> flavorList(FinanceSelectCommonVo commonVo) {
        LambdaQueryWrapper<FinanceBaseProduct> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.select(FinanceBaseProduct::getFlavor);
        queryWrapper.like(commonVo.getKeyword() != null && !commonVo.getKeyword().isEmpty(), FinanceBaseProduct::getFlavor, commonVo.getKeyword());
        queryWrapper.groupBy(FinanceBaseProduct::getFlavor);
        queryWrapper.orderByDesc(FinanceBaseProduct::getFlavor);
        List<FinanceBaseProduct> list = list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceBaseProductListDto> collect = list.stream()
                .filter(Objects::nonNull)
                .map(item -> {
                    FinanceBaseProductListDto dto = new FinanceBaseProductListDto();
                    dto.setFbpId(item.getFbpId());
                    dto.setPrdCode(item.getPrdCode());
                    dto.setPrdName(item.getPrdName());
                    dto.setFlavor(item.getFlavor());
                    return dto;
                }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<FinanceBaseProductListDto> specList(FinanceSelectCommonVo commonVo) {
        LambdaQueryWrapper<FinanceBaseProduct> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.select(FinanceBaseProduct::getSpec);
        queryWrapper.like(commonVo.getKeyword() != null && !commonVo.getKeyword().isEmpty(), FinanceBaseProduct::getSpec, commonVo.getKeyword());
        queryWrapper.groupBy(FinanceBaseProduct::getSpec);
        queryWrapper.orderByDesc(FinanceBaseProduct::getSpec);
        List<FinanceBaseProduct> list = list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceBaseProductListDto> collect = list.stream()
                .filter(Objects::nonNull)
                .map(item -> {
                    FinanceBaseProductListDto dto = new FinanceBaseProductListDto();
                    BeanUtils.copyProperties(item, dto);
                    return dto;
                }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<FinanceBaseProductListDto> productNameList(FinanceSelectCommonVo commonVo) {
        LambdaQueryWrapper<FinanceBaseProduct> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.select(FinanceBaseProduct::getPrdName);
        queryWrapper.like(commonVo.getKeyword() != null && !commonVo.getKeyword().isEmpty(), FinanceBaseProduct::getPrdName, commonVo.getKeyword());
        queryWrapper.groupBy(FinanceBaseProduct::getPrdName);
        queryWrapper.orderByDesc(FinanceBaseProduct::getPrdName);
        List<FinanceBaseProduct> list = list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceBaseProductListDto> collect = list.stream().map(item -> {
            FinanceBaseProductListDto dto = new FinanceBaseProductListDto();
            dto.setFbpId(item.getFbpId());
            dto.setPrdCode(item.getPrdCode());
            dto.setPrdName(item.getPrdName());
            dto.setFlavor(item.getFlavor());
            return dto;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<FinanceBaseProductListDto> seriesList(FinanceSelectCommonVo commonVo) {
        LambdaQueryWrapper<FinanceBaseProduct> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.select(FinanceBaseProduct::getSeries);
        queryWrapper.like(commonVo.getKeyword() != null && !commonVo.getKeyword().isEmpty(), FinanceBaseProduct::getSeries, commonVo.getKeyword());
        queryWrapper.groupBy(FinanceBaseProduct::getSeries);
        queryWrapper.orderByDesc(FinanceBaseProduct::getSeries);
        List<FinanceBaseProduct> list = list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceBaseProductListDto> collect = list.stream()
                .filter(Objects::nonNull)
                .map(item -> {
                    FinanceBaseProductListDto dto = new FinanceBaseProductListDto();
                    dto.setFbpId(item.getFbpId());
                    dto.setPrdCode(item.getPrdCode());
                    dto.setPrdName(item.getPrdName());
                    dto.setFlavor(item.getFlavor());
                    dto.setSeries(item.getSeries());
                    return dto;
                }).collect(Collectors.toList());
        return collect;
    }


}
