package com.link.bi.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.link.bi.domain.dao.IEcMarketDailyDetailDao;
import com.link.bi.domain.wq.MarketDetailWq;
import com.link.bi.pojo.request.MarketSummaryVo;
import com.link.bi.pojo.response.MarketSummaryDto;
import com.link.bi.service.IEcGoodsSupplyDemandService;
import com.link.bi.service.ISummaryMarketDailyDetailService;
import com.sfa.common.redis.keys.RedisKeyBi;
import com.sfa.common.redis.service.RedisService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-11-21 17
 * @describe :
 */
@Service
public class SummaryMarketDailyDetailImpl implements ISummaryMarketDailyDetailService {

    @Autowired
    IEcMarketDailyDetailDao ecMarketDailyDetailDao;
    @Autowired
    RedisService redisService;
    @Autowired
    IEcGoodsSupplyDemandService supplyDemandService;

    @Override
    public Map marketSummary(MarketSummaryVo summaryVo) {
        MarketDetailWq mqw = new MarketDetailWq();
        BeanUtils.copyProperties(summaryVo, mqw);
        Date date = mqw.getDate();
        mqw.setYear(DateUtil.year(date));
        mqw.setMonth(DateUtil.month(date) + 1);
        mqw.setFirstDay7(DateUtil.offsetDay(date, -7));
        List<MarketSummaryDto> marketSummaryDtos = ecMarketDailyDetailDao.summaryByPlatform(mqw);
        List<MarketSummaryDto> chartDtos = ecMarketDailyDetailDao.chartByPlatform(mqw);

        // 获取平台-年目标数据：
        boolean onlyPlatform = summaryVo.isOnlyPlatform();

        Map<String, String> tMap = redisService.getCacheMap(RedisKeyBi.MARKET_PLATFORM_TARGETED);
        for (MarketSummaryDto mDto : marketSummaryDtos) {
            mDto.setTargetSaleSum(onlyPlatform ? new BigDecimal(tMap.get(String.valueOf(mDto.getPlatformId()))) : BigDecimal.ZERO);
            tMap.remove(String.valueOf(mDto.getPlatformId()));
        }
        // 获取平台-年度和月度的货需数据：
        Map<String, Map<String, String>> supplyDemandYearAndMonthMap = supplyDemandService.getSupplyDemandYearAndMonth(mqw);
        for (MarketSummaryDto mDto : marketSummaryDtos) {
            mDto.setGoodsSupplyDemandCountY(ObjectUtil.isEmpty(supplyDemandYearAndMonthMap.get("year").get(String.valueOf(mDto.getPlatformId()))) ? BigDecimal.ZERO : new BigDecimal(supplyDemandYearAndMonthMap.get("year").get(String.valueOf(mDto.getPlatformId()))));
            mDto.setGoodsSupplyDemandCountM(ObjectUtil.isEmpty(supplyDemandYearAndMonthMap.get("month").get(String.valueOf(mDto.getPlatformId()))) ? BigDecimal.ZERO : new BigDecimal(supplyDemandYearAndMonthMap.get("month").get(String.valueOf(mDto.getPlatformId()))));
        }

        for (Map.Entry<String, String> entry : tMap.entrySet()) {
            String key = entry.getKey();
            MarketSummaryDto dto = new MarketSummaryDto().setPlatformId(Integer.valueOf(key))
                    .setTargetSaleSum(onlyPlatform ? new BigDecimal(entry.getValue()) : BigDecimal.ZERO);
            marketSummaryDtos.add(dto);
        }

        List<MarketSummaryDto> table = marketSummaryDtos.stream().sorted(Comparator.comparing(MarketSummaryDto::getPlatformId)).collect(Collectors.toList());
        Map<Integer, List<MarketSummaryDto>> chart = chartDtos.stream().collect(Collectors.groupingBy(MarketSummaryDto::getPlatformId));

        HashMap<String, Object> result = new HashMap<>();
        result.put("table", table);
        result.put("chart", chart);
        return result;
    }
}
