package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import lombok.Data;

/**
 * 商品-管理表
 * @TableName pro_info
 */
@TableName(value ="pro_info")
@Data
public class ProInfo implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer prdId;

    /**
     * 商品编码
     */
    private String prdCode;

    /**
     * 商品名称
     */
    private String prdName;

    /**
     * 商品系列
     */
    private Integer seriesId;

    /**
     * 商品系列
     */
    private String series;

    /**
     * 商品规格-69码
     */
    private String prdSpec;

    /**
     * 销售状态：1：在售，0：停售
     */
    private Integer saleStatus;

    /**
     * 0：正常；1：删除
     */
    private Integer status;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}