package com.link.bi.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.link.bi.domain.dao.IFinanceOrderDetailDao;
import com.link.bi.domain.entity.FinanceOrderDetail;
import com.link.bi.domain.mapper.FinanceOrderDetailMapper;
import com.link.bi.domain.wq.FinanceCostWq;
import com.link.bi.pojo.request.FinanceCostVo;
import com.link.bi.pojo.response.FinanceBiListDto;
import com.link.bi.pojo.response.FinanceExportBiListDto;
import com.link.bi.pojo.response.FinanceOrderDetailListDto;
import com.link.bi.service.FinanceOrderDetailService;
import com.sfa.common.core.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaTypeFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MimeType;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;

/**
 * 旺店通订单明细Service业务层处理
 *
 * @author lvbencai
 * @date 2025年01月07日17:00:16
 */
// 指定不同的数据源
//@DS("bi")
@Slf4j
@Service
public class FinanceOrderDetailServiceImpl extends ServiceImpl<FinanceOrderDetailMapper, FinanceOrderDetail> implements FinanceOrderDetailService {

    @Autowired
    IFinanceOrderDetailDao detailDao;

    @Override
    public PageInfo<FinanceBiListDto> selectBiFinanceCostList(FinanceCostVo financeCostVo) {
        FinanceCostWq qw = covertFinanceCostWq(financeCostVo);

        PageInfo<FinanceOrderDetail> orderDetailPageInfo = detailDao.selectBiFinanceCostList(qw);
        PageInfo<FinanceBiListDto> pageInfo = new PageInfo<>();
        BeanUtils.copyProperties(orderDetailPageInfo, pageInfo);
        pageInfo.setList(orderDetailPageInfo.getList().stream().map(item -> {
            FinanceBiListDto dto = new FinanceBiListDto();
            BeanUtils.copyProperties(item, dto);
            dto.setActualCostSum(item.getSumActualCostSum());
            dto.setStandardCostSum(item.getSumStandardCostSum());
            dto.setShareAmountSum(item.getShareAmountSum().setScale(2, BigDecimal.ROUND_HALF_UP));

            dto.setActualCostGrossProfitSum(dto.getShareAmountSum().subtract(dto.getActualCostSum()).setScale(2, BigDecimal.ROUND_HALF_UP));
            dto.setStandardCostGrossProfitSum(dto.getShareAmountSum().subtract(dto.getStandardCostSum()).setScale(2, BigDecimal.ROUND_HALF_UP));
            dto.setUid(IdUtil.simpleUUID());
            return dto;
        }).collect(Collectors.toList()));
        return pageInfo;
    }

    private FinanceCostWq covertFinanceCostWq(FinanceCostVo financeCostVo) {
        FinanceCostWq qw = new FinanceCostWq();
        BeanUtils.copyProperties(financeCostVo, qw);
        // 初始化开始日期和结束日期
        if (ObjectUtil.isAllNotEmpty(qw.getStartDate(), qw.getEndDate())) {
            qw.setStartDate(DateUtils.dateStart(DateUtils.dateStart(qw.getStartDate())));
            qw.setEndDate(DateUtils.dateStart(DateUtils.dateStart(DateUtils.addDays(qw.getEndDate(), 1))));
        } else {
            //默认 t-1 天的数据查询
            qw.setEndDate(DateUtils.dateStart(new Date()));
            qw.setStartDate(DateUtils.dateStart(DateUtils.addDays(new Date(), -1)));
        }
        return qw;
    }

    @Override
    public PageInfo<FinanceOrderDetailListDto> selectBiFinanceCostDetailPage(FinanceCostVo financeCostVo) {
        FinanceCostWq qw =  covertFinanceCostWq(financeCostVo);
        PageInfo<FinanceOrderDetail> financeOrderDetailPageInfo = detailDao.selectBiFinanceCostDetailList(qw);

        PageInfo<FinanceOrderDetailListDto> pageInfo = new PageInfo<>();
        BeanUtils.copyProperties(financeOrderDetailPageInfo, pageInfo);
        pageInfo.setList(financeOrderDetailPageInfo.getList().stream().map(item -> {
            FinanceOrderDetailListDto dto = new FinanceOrderDetailListDto();
            BeanUtils.copyProperties(item, dto);
            return dto;
        }).collect(Collectors.toList()));
        return pageInfo;
    }

    /**
     * 导出数据
     */
    @Override
    public void exportBiFinanceCostList(FinanceCostVo financeCostVo, HttpServletResponse response) {
        // 导出查询的数据
        financeCostVo.setPageNum(1);
        financeCostVo.setPageSize(1000000);
        PageInfo<FinanceBiListDto> financeBiListDtoPageInfo = this.selectBiFinanceCostList(financeCostVo);
        // easyExcel导出数据
        String fileNameOri = String.format("王小卤成本核算%s-%s订单明细信息-%s.xlsx", DateUtil.formatDate(financeCostVo.getStartDate()), DateUtil.formatDate(financeCostVo.getEndDate()), DateUtil.formatDate(new Date()));
        // 文件名中文名需要转义
        String fileName = null;
        try {
            fileName = URLEncoder.encode(fileNameOri, "UTF-8");

            String contentType = MediaTypeFactory.getMediaType(fileName).map(MimeType::toString).orElse("application/vnd.ms-excel");
            response.setContentType(contentType);
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            // 这里需要设置不关闭流
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            //设置背景颜色
            headWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontHeightInPoints((short) 11);
            headWriteCellStyle.setWriteFont(headWriteFont);
            //内容策略
            WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
            WriteFont contentWriteFont = new WriteFont();
            // 字体大小
            contentWriteFont.setFontHeightInPoints((short) 10);
            contentWriteCellStyle.setWriteFont(contentWriteFont);
            //设置 水平居中
            contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            HorizontalCellStyleStrategy horizontalCellStyleStrategy =
                    new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);

            Collection<?> dataList = financeBiListDtoPageInfo.getList();
            EasyExcel.write(response.getOutputStream(), FinanceExportBiListDto.class)
                    .autoCloseStream(Boolean.FALSE)
                    .excelType(ExcelTypeEnum.XLSX)
                    .registerWriteHandler(horizontalCellStyleStrategy)
                    .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())//自动列宽策略
//                    .registerWriteHandler(new SalesOrderExcelWriteHandler())
                    .sheet("成本信息")
                    //获取数据填充
                    .doWrite(dataList);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * 采集旺店通接口订单明细数据
     *
     * @param startTime
     * @param endTime
     */
//    @Override
//    public void syncWandiantongOrderDetail(Date startTime, Date endTime) {
//        try {

//            wangdiantongOrderService.dealOrders(startTime,endTime);
    // 计算时间间隔
//            long intervalMillis = endTime.getTime() - startTime.getTime();
    // 计算每个线程处理的时、间间隔
//            long threadIntervalMillis = intervalMillis / threadPoolConfig.getMaxPoolSize();
//            List<Future<List<WangdiantongOrder>>> futures = new ArrayList<>();
//            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor) customThreadPool;

    // 创建并提交线程任务
//            List<Callable<List<WangdiantongOrder>>> tasks = new ArrayList<>();
//            for (int i = 0; i < threadPoolConfig.getCorePoolSize(); i++) {
//                Date threadStartTime = new Date(startTime.getTime() + i * threadIntervalMillis);
//                Date threadEndTime = new Date(threadStartTime.getTime() + threadIntervalMillis);
//                Callable<List<WangdiantongOrder>> task = () -> dealOrders(threadStartTime, threadEndTime);
//                tasks.add(task);
//            }
//            List<List<WangdiantongOrder>> results = new ArrayList<>();
//            List<Future<List<WangdiantongOrder>>> futures = ((ThreadPoolTaskExecutor) customThreadPool).getThreadPoolExecutor().invokeAll(tasks);
//            for (Future<List<WangdiantongOrder>> future : futures) {
//                results.add(future.get());
//            }
//            log.info("多线程共处理了{}条数据", results.size());
//        } catch (Exception e) {
//            log.error(e.getMessage(), e);
//        }
//    }


}
