package com.link.bi.service.impl;

import cn.hutool.core.date.DateUtil;
import com.link.bi.domain.dao.IEcMarketDailyDetailDao;
import com.link.bi.domain.wq.MarketDetailWq;
import com.link.bi.pojo.request.MarketSummaryVo;
import com.link.bi.pojo.response.MarketSummaryDto;
import com.link.bi.service.ISummaryMarketDailyDetailService;
import com.sfa.common.redis.keys.RedisKeyBi;
import com.sfa.common.redis.service.RedisService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-11-21 17
 * @describe :
 */
@Service
public class SummaryMarketDailyDetailImpl implements ISummaryMarketDailyDetailService {

    @Autowired
    IEcMarketDailyDetailDao ecMarketDailyDetailDao;
    @Autowired
    RedisService redisService;

    @Override
    public Map marketSummary(MarketSummaryVo summaryVo) {
        MarketDetailWq mqw = new MarketDetailWq();
        BeanUtils.copyProperties(summaryVo, mqw);
        Date date = mqw.getDate();
        mqw.setYear(DateUtil.year(date));
        mqw.setMonth(DateUtil.month(date) + 1);
        mqw.setFirstDay7(DateUtil.offsetDay(date,-7));
        List<MarketSummaryDto> marketSummaryDtos = ecMarketDailyDetailDao.summaryByPlatform(mqw);
        List<MarketSummaryDto> chartDtos = ecMarketDailyDetailDao.chartByPlatform(mqw);

        // 获取平台-年目标数据：
        boolean onlyPlatform = summaryVo.isOnlyPlatform();

        Map<String, String> tMap = redisService.getCacheMap(RedisKeyBi.MARKET_PLATFORM_TARGETED);
        for (MarketSummaryDto mDto : marketSummaryDtos) {
            mDto.setTargetSaleSum(onlyPlatform ? new BigDecimal(tMap.get(mDto.getPlatformId() + "-" + mDto.getPlatform())) : BigDecimal.ZERO);
            tMap.remove(mDto.getPlatformId() + "-" + mDto.getPlatform());
        }

        for (Map.Entry<String, String> entry : tMap.entrySet()) {
            String[] split = StringUtils.split(entry.getKey(), "-");
            MarketSummaryDto dto = new MarketSummaryDto().setPlatformId(Integer.valueOf(split[0]))
                    .setPlatform(split[1])
                    .setTargetSaleSum(onlyPlatform ? new BigDecimal(entry.getValue()) : BigDecimal.ZERO);
            marketSummaryDtos.add(dto);
        }
        
        List<MarketSummaryDto> table = marketSummaryDtos.stream().sorted(Comparator.comparing(MarketSummaryDto::getPlatformId)).collect(Collectors.toList());
        Map<Integer, List<MarketSummaryDto>> chart = chartDtos.stream().collect(Collectors.groupingBy(MarketSummaryDto::getPlatformId));

        HashMap<String, Object> result = new HashMap<>();
        result.put("table",table);
        result.put("chart",chart);
        return  result;
    }
}
