package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 电商-每日销售明细
 * @TableName ec_market_daily_detail
 */
@TableName(value ="ec_market_daily_detail")
@Data
public class EcMarketDailyDetail implements Serializable {
    /**
     * 电商-每日销售明细-id
     */
    @TableId(type = IdType.AUTO)
    private Long emddId;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 月份
     */
    private Integer month;

    /**
     * 日期
     */
    private Date date;

    /**
     * 平台
     */
    private Integer platformId;

    /**
     * 1 天猫; 2 抖音; 3 拼多多; 4 京东……
     */
    private String platform;

    /**
     * 旺店通店铺编码
     */
    private String storeCode;

    /**
     * 旺店通店铺
     */
    private String storeName;

    /**
     * 仓库
     */
    private String storage;

    /**
     * 分类
     */
    private String mClass;

    /**
     * 货品品类id
     */
    private Integer seriesId;

    /**
     * 货品品类
     */
    private String series;

    /**
     * 商品/货品编码
     */
    private String prdCode;

    /**
     * 商品/货品名称
     */
    private String prdName;

    /**
     * 商品/货品-简称
     */
    private String prdByname;

    /**
     * 商品规格-69码(绝大部分)
     */
    private String prdSpec;

    /**
     * 均价
     */
    private BigDecimal averagePrice;

    /**
     * 分类(class)以上，大类
     */
    private String bigClass;

    /**
     * 实际销售量
     */
    private BigDecimal saleCount;

    /**
     * 实际销售额
     */
    private BigDecimal saleSum;

    /**
     * 付款总金额
     */
    private BigDecimal payAmount;

    /**
     * 销售总金额
     */
    private BigDecimal saleAmount;

    /**
     * 发货数量
     */
    private BigDecimal shipmentsCount;

    /**
     * 售前退款量
     */
    private BigDecimal preSaleRcount;

    /**
     * 售前退款金额
     */
    private BigDecimal preSaleRsum;

    /**
     * 售后退货量
     */
    private BigDecimal afterSaleRcount;

    /**
     * 售后退款金额
     */
    private BigDecimal afterSaleRsum;

    /**
     * 异常仓销量
     */
    private BigDecimal abnormalCount;

    /**
     * 退货率（%）
     */
    private Integer ratioSaleReturn;

    /**
     * 售前退款率（%）
     */
    private Integer ratioPreSaleRefund;

    /**
     * 售前退款率（%）
     */
    private Integer ratioAfterSaleReturn;

    /**
     * 商/货品规格名称
     */
    private String prdSpecName;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 单品属性1
     */
    private String nature1;

    /**
     * 单品属性2
     */
    private String nature2;

    /**
     * 单品属性3
     */
    private String nature3;

    /**
     * 发货总金额
     */
    private BigDecimal shipmentsAmount;

    /**
     * 邮费
     */
    private BigDecimal freight;

    /**
     * 邮资成本
     */
    private BigDecimal freightCost;

    /**
     * 单品属性4
     */
    private String nature4;

    /**
     * 单品属性5
     */
    private String nature5;

    /**
     * 单品属性6
     */
    private String nature6;

    /**
     * 单品金额1
     */
    private BigDecimal singlePrice1;

    /**
     * 单品金额2
     */
    private BigDecimal singlePrice2;

    /**
     * 供应商名称
     */
    private String dealerName;

    /**
     * 零售价
     */
    private BigDecimal retailPrice;

    /**
     * 付款量
     */
    private BigDecimal payCount;

    /**
     * 货品标签
     */
    private String prdTag;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}