package com.link.bi.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.link.bi.domain.dao.IPrdTagDao;
import com.link.bi.domain.entity.PrdTag;
import com.link.bi.domain.entity.PrdTagInfo;
import com.link.bi.domain.mapper.PrdTagInfoMapper;
import com.link.bi.domain.mapper.PrdTagMapper;
import com.link.bi.domain.wq.PrdTagWq;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.enums.StatusType;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.common.core.utils.StringUtils;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-12-04 16
 * @describe :
 */
@Service
public class PrdTagDaoImpl implements IPrdTagDao {

    @Autowired
    private PrdTagMapper prdTagMapper;
    @Autowired
    private PrdTagInfoMapper prdTagInfoMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public synchronized void addTags(String tagName, Map<String, Map<String, String>> tagMap) {
        Integer count = prdTagMapper.selectCountBy(tagName);
        if (count > 0) {
            throw new WXLSQLException(ECode.DB_TABLE_UNIQUE_EXIST, "标签名");
        }

        String username = SecurityUtils.getUsername();
        Long userId = SecurityUtils.getUserId();
        /**
         * 保存标签
         */
        PrdTag prdTag = new PrdTag();
        prdTag.setCreateBy(username);
        prdTag.setCreateUserId(userId);
        prdTag.setPrdTagName(tagName);
        prdTagMapper.insert(prdTag);

        Integer prdTagId = prdTag.getPrdTagId();

        /**
         * 保存value：商品列表
         */
        List<PrdTagInfo> dos = new ArrayList<>();
        tagMap.forEach((seriesId, prds) -> {
            String[] split = seriesId.split("-");

            prds.forEach((prdCode, prdName) -> {
                PrdTagInfo entity = new PrdTagInfo();
                entity.setCreateUserId(userId);
                entity.setCreateBy(username);
                entity.setPrdTagId(prdTagId)
                        .setPrdTagName(tagName)
                        .setPrdCode(prdCode)
                        .setPrdName(prdName)
                        .setSeriesId(Integer.parseInt(split[0]))
                        .setSeries(split[1]);
                dos.add(entity);
            });
        });
        prdTagInfoMapper.adds(dos);
    }

    @Override
    public PageInfo pageTag(PrdTagWq prdTagWq) {
        LambdaQueryWrapper<PrdTag> qw = buildQwTag(prdTagWq);
        Page<PrdTag> page = prdTagMapper.selectPage(TableSupport.pageI(), qw);
        PageInfo pageInfo = new PageInfo(page);
        return pageInfo;
    }

    @Override
    public List selectTagInfos(PrdTagWq prdTagWq) {
        LambdaQueryWrapper<PrdTagInfo> qw = buildQwTagInfo(prdTagWq);
        List<PrdTagInfo> prdTagInfos = prdTagInfoMapper.selectList(qw);
        return prdTagInfos;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteTag(Integer prdTagId) {
        PrdTag prdTag = prdTagMapper.selectById(prdTagId);
        prdTag.setUpdateBy(SecurityUtils.getUsername());
        prdTag.setUpdateUserId(SecurityUtils.getUserId());

        prdTag.setFlag(prdTag.getFlag() + 1);
        prdTag.setDelFlag(prdTag.getFlag() + "");
        prdTag.setUpdateTime(null);
        prdTagMapper.updateById(prdTag);

        PrdTagInfo prdTagInfo = new PrdTagInfo();
        BeanUtils.copyProperties(prdTag,prdTagInfo);
        prdTagInfo.setPrdTagId(prdTagId);

        prdTagInfoMapper.updateByPrdTagId(prdTagInfo);
    }

    private LambdaQueryWrapper<PrdTag> buildQwTag(PrdTagWq prdTagWq) {
        LambdaQueryWrapper<PrdTag> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(prdTagWq.getTagNameLike())) {
            qw.like(PrdTag::getPrdTagName, prdTagWq.getTagNameLike());
        }
        qw.eq(PrdTag::getDelFlag, StatusType.getDelFlag());
        return qw;
    }

    private LambdaQueryWrapper<PrdTagInfo> buildQwTagInfo(PrdTagWq prdTagWq) {
        LambdaQueryWrapper<PrdTagInfo> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(prdTagWq.getPrdTagId())) {
            qw.eq(PrdTagInfo::getPrdTagId, prdTagWq.getPrdTagId());
        }
//        todo 待完善
        System.out.println(StatusType.getDelFlag());
        qw.eq(PrdTagInfo::getDelFlag, StatusType.getDelFlag());
        return qw;
    }
}
