package com.link.bi.controller.core;

import cn.hutool.core.collection.CollectionUtil;
import com.link.bi.pojo.request.PrdTagVo;
import com.link.bi.service.IPrdTagCoreService;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.CheckedException;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2024-12-04 15
 * @describe : 商品标签分配管理
 */
@RestController
@RequestMapping("/prd_tage/core")
public class PrdTagCoreController {

    @Autowired
    IPrdTagCoreService iPrdTagCoreService;

    @RequiresPermissions("bi:prdtag:list")
    @PostMapping()
    public void addTags(@RequestBody PrdTagVo prdTagVo) {
        if (CollectionUtil.isEmpty(prdTagVo.getTagMap())){
            throw new CheckedException(ECode.LEAST_INCLUDE_ONE_ERROR);
        }
        iPrdTagCoreService.addTags(prdTagVo.getTagName(), prdTagVo.getTagMap());
    }

    @RequiresPermissions("bi:prdtag:list")
    @DeleteMapping("/{prdTagId}")
    public void deleteTag(@PathVariable("prdTagId") Integer prdTagId){
        iPrdTagCoreService.deleteTag(prdTagId);
    }
}
