package com.link.bi.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.link.bi.domain.dao.IFinanceBaseZbjTypeDao;
import com.link.bi.domain.entity.FinanceBaseZbjType;
import com.link.bi.domain.mapper.FinanceBaseZbjTypeMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : lvbencai
 * @date : 2025-01-14 17:30:00
 * @describe : 财务抖音订单明细中，直播间类型
 */
@Slf4j
@Service
public class FinanceBaseZbjTypeDaoImpl implements IFinanceBaseZbjTypeDao {
    @Autowired
    private FinanceBaseZbjTypeMapper mapper;

    @Override
    public List<FinanceBaseZbjType> list(LambdaQueryWrapper<FinanceBaseZbjType> queryWrapper) {
        return mapper.selectList(new LambdaQueryWrapper<>());
    }

    @Override
    public Page<FinanceBaseZbjType> page(Page<FinanceBaseZbjType> page, QueryWrapper<FinanceBaseZbjType> queryWrapper) {
        return mapper.selectPage(page, queryWrapper);
    }

    @Override
    public void removeByIds(List<Long> idsToDelete) {
        mapper.deleteBatchIds(idsToDelete);
    }

    @Override
    public void saveBatch(List<FinanceBaseZbjType> recordsToSave) {
        //TODO 待完善
//        mapper.
    }

    @Override
    public void updateBatchById(List<FinanceBaseZbjType> recordsToUpdate) {
        //TODO 待完善
//        mapper.u
    }
}
