package com.link.bi.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.bi.domain.dao.IFinanceBaseProductDao;
import com.link.bi.domain.entity.FinanceBaseProduct;
import com.link.bi.domain.mapper.FinanceBaseProductMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : lvbencai
 * @date : 2025-01-14 17:00:00
 * @describe :财务抖音订单数据 商品的信息DAO
 */
@Slf4j
@Service
public class FinanceBaseProductDaoImpl implements IFinanceBaseProductDao {
    @Autowired
    private FinanceBaseProductMapper mapper;

    @Override
    public List<FinanceBaseProduct> list(LambdaQueryWrapper<FinanceBaseProduct> objectLambdaQueryWrapper) {
        return mapper.selectList(objectLambdaQueryWrapper);
    }
}
