package com.link.bi.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.link.bi.domain.dao.IOppoCmmDao;
import com.link.bi.domain.entity.OppoCmm;
import com.link.bi.domain.mapper.OppoCmmMapper;
import com.link.bi.domain.wq.OppoCmmWq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : lvbencai
 * @date : 2024-12-20 10:32
 * @describe :
 */
@Service
public class OppoCmmDaoImpl implements IOppoCmmDao {
    @Autowired
    OppoCmmMapper oppoCmmMapper;


    @Override
    public List<OppoCmm> selectList(OppoCmmWq wq) {
        // 查询数据库数据
        QueryWrapper<OppoCmm> wrapper = new QueryWrapper<>();
        wrapper.select("`date`,name,SUM(gkrc_num) AS gkrc_num_total, SUM(sale_sum) AS sale_sum_total ");
        wrapper.between(ObjectUtil.isNotEmpty(wq.getStartDate()), "date", wq.getStartDate(), wq.getEndDate());
        wrapper.groupBy("name,`date`");
        wrapper.orderByDesc("`date`");
        return oppoCmmMapper.selectList(wrapper);

    }
}
