package com.link.bi.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.link.bi.domain.dao.IOppoSycmDao;
import com.link.bi.domain.entity.OppoSycm;
import com.link.bi.domain.wq.OppoSycmWq;
import com.link.bi.pojo.request.OppoSycmVo;
import com.link.bi.pojo.response.OppoSycmDto;
import com.link.bi.pojo.response.OppoSycmPrdInfoDto;
import com.link.bi.service.IOppoSycmService;
import com.sfa.common.core.utils.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 电商竞品-生意参谋竞品数据（天猫）Service业务层处理
 *
 * @author admin
 * @date 2024-12-20
 */
@Service
public class OppoSycmServiceImpl implements IOppoSycmService {

    @Autowired
    IOppoSycmDao sycmDao;

    @Override
    public List<List<OppoSycmDto>> selectOppoSycmPrdBi(OppoSycmVo sycmVo) {
        // 设置默认入参时间，倒数30天
        // Optional判断入参为空设置默认值
        Date startDate = Optional.ofNullable(sycmVo.getStartDate())
                .orElse(DateUtils.addDays(DateUtils.dateStart(new Date()), -31));
        Date endDate = Optional.ofNullable(sycmVo.getEndDate()).orElse(
                DateUtils.addDays(DateUtils.dateStart(new Date()), -1));
        sycmVo.setStartDate(startDate);
        sycmVo.setEndDate(endDate);

        OppoSycmWq wq = new OppoSycmWq();
        BeanUtils.copyProperties(sycmVo, wq);

        // prdId不为空，则prdId转成List
        if (ObjectUtil.isNotEmpty(sycmVo.getPrdId())) {
            List<String> prdIds = Arrays.asList(sycmVo.getPrdId().split(","));
            wq.setPrdIds(prdIds);
        }
        if (ObjectUtil.isNotEmpty(sycmVo.getPlatformStore())) {
            List<String> platformStores = Arrays.asList(sycmVo.getPlatformStore().split(","));
            wq.setPlatformStores(platformStores);
        }

        List<OppoSycm> oppoSycms = sycmDao.selectOppoSycmPrdList(wq);

        List<List<OppoSycmDto>> lists = new ArrayList<>();
        // 按照name分成不同的list
        Map<String, List<OppoSycm>> map = oppoSycms.stream()
                .collect(Collectors.groupingBy(OppoSycm::getPrdId));

        map.forEach((name, objects) -> {
            List<OppoSycmDto> oppoCmmVOS = new ArrayList<>();
            objects.forEach(obj -> {
                OppoSycmDto vo = new OppoSycmDto();
                BeanUtils.copyProperties(obj, vo);
                oppoCmmVOS.add(vo);
            });
            lists.add(oppoCmmVOS);
        });
        return lists;
    }

    @Override
    public List<OppoSycmPrdInfoDto> selectOppoSycmPrdInfo() {
        List<OppoSycm> oppoSycms = sycmDao.selectOppoSycmPrdInfo();
        // 转换成结果
        List<OppoSycmPrdInfoDto> oppoCmmVOS = new ArrayList<>();
        oppoSycms.forEach(obj -> {
            OppoSycmPrdInfoDto vo = new OppoSycmPrdInfoDto();
            BeanUtils.copyProperties(obj, vo);
            oppoCmmVOS.add(vo);
        });
        return oppoCmmVOS;
    }
}
