package com.link.bi.service.impl;

import com.link.bi.domain.dao.IOppoSycmDao;
import com.link.bi.domain.entity.OppoSycm;
import com.link.bi.domain.wq.OppoSycmWq;
import com.link.bi.pojo.request.OppoSycmDto;
import com.link.bi.pojo.response.OppoSycmVO;
import com.link.bi.service.IOppoSycmService;
import com.sfa.common.core.utils.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 电商竞品-生意参谋数据（天猫）Service业务层处理
 *
 * @author admin
 * @date 2024-12-20
 */
@Service
public class OppoSycmServiceImpl implements IOppoSycmService
{

    @Autowired
    IOppoSycmDao sycmDao;
    @Override
    public List<List<OppoSycmVO>> selectOppoSycmStoreBi(OppoSycmDto oppoSycmDto) {
        // 设置默认入参时间，倒数30天
        // Optional判断入参为空设置默认值
        Date startDate = Optional.ofNullable(oppoSycmDto.getStartDate())
                .orElse(DateUtils.addDays(DateUtils.dateStart(new Date()), -31));
        Date endDate = Optional.ofNullable(oppoSycmDto.getEndDate()).orElse(
                DateUtils.addDays(DateUtils.dateStart(new Date()), -1));
        oppoSycmDto.setStartDate(startDate);
        oppoSycmDto.setEndDate(endDate);

        OppoSycmWq wq = new OppoSycmWq();

        BeanUtils.copyProperties(oppoSycmDto, wq);
        List<OppoSycm> oppoSycms = sycmDao.selectList(wq);

        List<List<OppoSycmVO>> lists = new ArrayList<>();
        // 按照name分成不同的list
        Map<String, List<OppoSycm>> map = oppoSycms.stream()
                .collect(Collectors.groupingBy(OppoSycm::getPlatformStore));

        map.forEach((name, objects) -> {
//            System.out.println("Name: " + name);
            List<OppoSycmVO> oppoCmmVOS = new ArrayList<>();
            objects.forEach(obj -> {
                OppoSycmVO vo = new OppoSycmVO();
                BeanUtils.copyProperties(obj, vo);
                 oppoCmmVOS.add(vo);
            });
            lists.add(oppoCmmVOS);
        });
        return lists;
    }
}
