package com.link.bi.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.link.bi.domain.entity.EcGoodsSupplyDemand;
import com.link.bi.domain.wq.MarketDetailWq;
import com.link.bi.pojo.request.EcStoreVo;
import com.sfa.common.core.web.domain.PageInfo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * 电商-货物供需Service接口
 *
 * @author admin
 * @date 2024-12-05
 */
public interface IEcGoodsSupplyDemandService extends IService<EcGoodsSupplyDemand> {
    List<EcGoodsSupplyDemand> importData(MultipartFile ecGoodsSupplyDemand, Integer year);


    // 批量保存
    void batchSaveEcGoodsSupplyDemands(List<EcGoodsSupplyDemand> demandList);

    void deleteByYear(Integer year);

    Map<String, Map<String, String>> getSupplyDemandYearAndMonth(MarketDetailWq mqw);

    PageInfo selectPage(EcStoreVo ecStoreVo);
}
