package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.sfa.common.core.annotation.Excel;
import lombok.Data;

import java.util.Date;

/**
 * 电商-货物供需对象 ec_goods_supply_demand
 *
 * @author admin
 * @date 2024-12-05
 */
@TableName(value ="ec_goods_supply_demand")
@Data
public class EcGoodsSupplyDemand
{
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    /** 主键id */
    @TableId(type = IdType.AUTO)
    private Long supplyDemandId;

    /** 年 */
    @Excel(name = "年")
    private Long year;

    /** 月 */
    @Excel(name = "月")
    private Long month;

    /** 周 */
    @Excel(name = "周")
    private Integer week;

    /** 统计日期类型：1年 2月 3周 4日 */
    @Excel(name = "统计日期类型：1年 2月 3周 4日")
    private Long reportDateType;

    /** 统计日期开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "统计日期开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date reportDateBegin;

    /** 统计日期结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "统计日期结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date reportDateEnd;

    /** 商品/货品编码 */
    @Excel(name = "商品/货品编码")
    private String prdCode;

    /** 商品/货品名称 */
    @Excel(name = "商品/货品名称")
    private String prdName;

    /** 商品条码,69码 */
    @Excel(name = "商品条码,69码")
    private String prdBarcode;

    /** 商品/货品状态 */
    @Excel(name = "商品/货品状态")
    private Long prdStatus;

    /** 商品系列id */
    @Excel(name = "商品系列id")
    private Integer seriesId;

    /** 商品系列 */
    @Excel(name = "商品系列")
    private String series;

    /** 平台id */
    @Excel(name = "平台id")
    private Long platformId;

    /** platform平台:1 天猫; 2 抖音; 3 拼多多; 4 京东; 5 私域; 6 分销; 7 线下; 8 样品; 9 团购; 10 其他; */
    @Excel(name = "platform平台:1 天猫; 2 抖音; 3 拼多多; 4 京东; 5 私域; 6 分销; 7 线下; 8 样品; 9 团购; 10 其他;")
    private String platform;

    /** 货需数量 */
    @Excel(name = "货需数量")
    // 做校验下 是否为正整数
    private Long supplyDemandAmount;

    @Excel(name = "创建时间")
    private Date createTime;

    /** 创建人id */
    @Excel(name = "创建人id")
    private Long createUserId;


    /** 创建人 */
    @Excel(name = "创建人")
    private String createBy;

    /** 修改人id */
    @Excel(name = "修改人id")
    private Long updateUserId;

    /** 修改人 */
    @Excel(name = "修改人")
    private Long updateBy;

    @Excel(name = "修改时间")
    private Date updateTime;
}
