package com.link.bi.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.link.bi.domain.dao.IEcStoreDao;
import com.link.bi.domain.entity.EcStore;
import com.link.bi.domain.mapper.EcStoreMapper;
import com.link.bi.domain.wq.EcStoreWq;
import com.link.bi.pojo.response.EcStoreDto;
import com.sfa.common.core.enums.ECode;
import com.sfa.common.core.exception.WXLSQLException;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.core.web.page.TableSupport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-11-20 16
 * @describe :
 */
@Service
public class EcStoreDaoImpl implements IEcStoreDao {
    @Autowired
    EcStoreMapper ecStoreMapper;

    @Override
    public PageInfo selectPage(EcStoreWq wq) {
        LambdaQueryWrapper<EcStore> qWrapper = builderWq(wq);
        Page<EcStore> page = ecStoreMapper.selectPage(TableSupport.pageI(), qWrapper);
        PageInfo pageInfo = new PageInfo<>(page);
        return pageInfo;
    }

    @Override
    public void add(EcStoreDto dto) {
        try {
            EcStore entity = new EcStore();
            BeanUtils.copyProperties(dto, entity);
            ecStoreMapper.insert(entity);
        } catch (Exception e) {
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'store_code_unique'") || eMsg.contains("for key 'store_name_unique'")) {
                throw new WXLSQLException(ECode.DB_TABLE_UNIQUE_EXIST, "旺店通店铺");
            }
        }
    }

    @Override
    public void editStore(EcStoreDto dto) {
        try {
            EcStore entity = new EcStore();
            BeanUtils.copyProperties(dto, entity);
            ecStoreMapper.updateById(entity);
        } catch (Exception e) {
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'store_code_unique'") || eMsg.contains("for key 'store_name_unique'")) {
                throw new WXLSQLException(ECode.DB_TABLE_UNIQUE_EXIST, "旺店通店铺");
            }
        }
    }

    private LambdaQueryWrapper<EcStore> builderWq(EcStoreWq wq) {
        LambdaQueryWrapper<EcStore> wrapper = new LambdaQueryWrapper<>();
        if (Objects.nonNull(wq.getPlatformId())) {
            wrapper.eq(EcStore::getPlatformId, wq.getPlatformId());
        }
        if (Objects.nonNull(wq.getStatus())) {
            wrapper.eq(EcStore::getStatus, wq.getStatus());
        }
        if (StringUtils.isNotBlank(wq.getStoreNameLike())) {
            wrapper.like(EcStore::getStoreName, wq.getStoreNameLike());
        }
        return wrapper;
    }
}
