package com.link.bi.service.impl;

import com.link.bi.domain.dao.IPrdTagDao;
import com.link.bi.domain.dao.IProductDao;
import com.link.bi.pojo.request.PrdTagVo;
import com.link.bi.pojo.response.PrdInfoDto;
import com.link.bi.service.IPrdTagCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-12-04 15
 * @describe :
 */
@Service
public class PrdTagCoreServiceImpl implements IPrdTagCoreService {
    @Autowired
    IPrdTagDao prdTagDao;
    @Autowired
    IProductDao productDao;

    @Override
    public void addTags(PrdTagVo prdTagVo) {
        List<String> prdCodes = prdTagVo.getPrdCodes();
        List<PrdInfoDto> prdInfos = productDao.selectListByCodes(prdCodes);
        prdTagDao.addTags(prdTagVo.getTagName(),prdInfos);
    }

    @Override
    public void deleteTag(Integer prdTagId) {
        prdTagDao.deleteTag(prdTagId);
    }
}
