package com.link.bi.domain.dao.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.link.bi.domain.dao.IFinanceOrderDetailDao;
import com.link.bi.domain.entity.FinanceOrderDetail;
import com.link.bi.domain.mapper.FinanceOrderDetailMapper;
import com.link.bi.domain.wq.FinanceCostWq;
import com.sfa.common.core.web.page.TableSupport;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * @author : lvbencai
 * @date : 2024-12-10 16
 * @describe : 旺店通订单明细
 */
@Slf4j
@Service
public class FinanceOrderDetailDaoImpl implements IFinanceOrderDetailDao {
    @Autowired
    FinanceOrderDetailMapper detailMapper;
    /**
     * 查询分页数据
     * @param wq
     * @return
     */
    @Override
    public PageInfo<FinanceOrderDetail> selectBiFinanceCostList(FinanceCostWq wq) {
        // 查询分页数据
        Page<Object> objectPage = TableSupport.pageI();
        PageHelper.startPage((int) objectPage.getCurrent(), (int) objectPage.getSize());

        List<FinanceOrderDetail> financeOrderDetails = detailMapper.selectBiFinanceCostList( wq);
        PageInfo<FinanceOrderDetail> pageInfo = new PageInfo<>(financeOrderDetails);
        return pageInfo;

    }

    @Override
    public PageInfo<FinanceOrderDetail> selectBiFinanceCostDetailList(FinanceCostWq wq) {
        // 查询分页数据
        Page<Object> objectPage = TableSupport.pageI();
        PageHelper.startPage((int) objectPage.getCurrent(), (int) objectPage.getSize());

        List<FinanceOrderDetail> financeOrderDetails = detailMapper.selectBiFinanceCostDetailList( wq);
        PageInfo<FinanceOrderDetail> pageInfo = new PageInfo<>(financeOrderDetails);
        return pageInfo;
    }
}
