package com.link.bi.domain.dao.impl;

import com.baomidou.dynamic.datasource.annotation.Slave;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.bi.domain.dao.IFinanceOrderDao;
import com.link.bi.domain.entity.FinanceOrder;
import com.link.bi.domain.mapper.FinanceOrderMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author : lvbencai
 * @date : 2025-01-14 17:31:05
 * @describe : 财务抖音订单数据
 */
@Slf4j
@Service
public class FinanceOrderDaoImpl implements IFinanceOrderDao {

    @Autowired
    private FinanceOrderMapper  orderMapper;

    @Slave
    public Date selectOrderLatest(Integer syncType) {
        // 查询最新发货日期
        List<FinanceOrder> objects = orderMapper.selectList(
                new LambdaQueryWrapper<FinanceOrder>()
                         // 默认查询xxljob自动同步时间
                        .eq(FinanceOrder::getSyncType,syncType)
                        .orderByDesc(FinanceOrder::getModified)
                        .last("LIMIT 1"));
        if(ObjectUtils.isNotEmpty(objects)){
            // 最新的数据日期
            return objects.get(0).getModified();
        }else{
            // 默认上个月的第一天 00:00:00
            return DateUtils.addMonths(new Date(),-1);
        }
    }

}
