package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.sfa.common.core.web.domain.BaseDo;
import lombok.Data;
/**
 * 电商-店铺对象 ec_store
 *
 * @author admin
 * @date 2024-11-20
 */
@TableName(value ="ec_store")
@Data
public class EcStore extends BaseDo
{
    /**
     * 店铺id
     */
    @TableId(type = IdType.AUTO)
    private Integer storeId;

    /**
     * 旺店通店铺编码
     */
    private String storeCode;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 渠道
     */
    private Integer channelId;

    /**
     * 1 电商; 2 线下;
     */
    private String channel;

    /**
     * 平台
     */
    private Integer platformId;

    /**
     * 1 天猫; 2 抖音; 3 拼多多; 4 京东; 5 私域; 6 分销; 7 线下; 8 样品; 9 团购; 10 其他;
     */
    private String platform;

    /**
     * 0正常,1停用
     */
    private Integer status;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}