package com.link.bi.service.impl;

import com.link.bi.domain.dao.IPrdTagDao;
import com.link.bi.domain.wq.PrdTagWq;
import com.link.bi.pojo.request.PrdTagVo;
import com.link.bi.service.IPrdTagQueryService;
import com.sfa.common.core.web.domain.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-12-04 18
 * @describe :
 */
@Service
public class PrdTagQueryServiceImpl implements IPrdTagQueryService {

    @Autowired
    IPrdTagDao prdTagDao;

    /**
     * 分页查询标签
     */
    @Override
    public PageInfo pageTag(PrdTagVo prdTagVo) {
        PrdTagWq prdTagWq = new PrdTagWq();
        prdTagWq.setTagNameLike(prdTagVo.getTagNameLike());
        return prdTagDao.pageTag(prdTagWq);
    }

    @Override
    public List selectTagInfos(PrdTagVo prdTagVo) {
        PrdTagWq prdTagWq = new PrdTagWq();
        prdTagWq.setPrdTagId(prdTagVo.getPrdTagId());
        return prdTagDao.selectTagInfos(prdTagWq);
    }
}
