package com.link.bi.service.impl;

import com.link.bi.domain.dao.IOppoCmmDao;
import com.link.bi.domain.entity.OppoCmm;
import com.link.bi.domain.wq.OppoCmmWq;
import com.link.bi.pojo.request.OppoCmmVo;
import com.link.bi.pojo.response.OppoCmmDto;
import com.link.bi.service.IOppoCmmService;
import com.sfa.common.core.utils.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 电商竞品-蝉妈妈数据（抖音后台）Service业务层处理
 *
 * @author admin
 * @date 2024-12-19
 */
@Service
public class OppoCmmServiceImpl implements IOppoCmmService {
    @Autowired
    IOppoCmmDao oppoCmmDao;

    @Override
    public List<List<OppoCmmDto>> selectOppoCmmZbjBiList(OppoCmmVo oppoCmmDto) {
        // 设置默认入参时间，倒数30天
        // Optional判断入参为空设置默认值
        Date startDate = Optional.ofNullable(oppoCmmDto.getStartDate())
                .orElse(DateUtils.addDays(DateUtils.dateStart(new Date()), -31));
        Date endDate = Optional.ofNullable(oppoCmmDto.getEndDate()).orElse(
                DateUtils.addDays(DateUtils.dateStart(new Date()), -1));
        oppoCmmDto.setStartDate(startDate);
        oppoCmmDto.setEndDate(endDate);

        OppoCmmWq wq = new OppoCmmWq();

        BeanUtils.copyProperties(oppoCmmDto, wq);
        List<OppoCmm> oppoCmms = oppoCmmDao.selectList(wq);
        List<List<OppoCmmDto>> vos = new ArrayList<>();
        // 按照name分成不同的list
        Map<String, List<OppoCmm>> map = oppoCmms.stream()
                .collect(Collectors.groupingBy(OppoCmm::getName));

        map.forEach((name, objects) -> {
            List<OppoCmmDto> oppoCmmVOS = new ArrayList<>();
            objects.forEach(obj -> {
                OppoCmmDto vo = new OppoCmmDto();
                BeanUtils.copyProperties(obj, vo);
                vo.setSaleSumTotal(vo.getSaleSumTotal().setScale(2));
                oppoCmmVOS.add(vo);
            });
            vos.add(oppoCmmVOS);
        });
        return vos;
    }
}
