package com.link.bi.controller.core;

import com.link.bi.pojo.request.EcStoreVo;
import com.link.bi.pojo.response.EcStoreDto;
import com.link.bi.service.IEcStoreService;
import com.sfa.common.log.annotation.Log;
import com.sfa.common.log.enums.BusinessType;
import com.sfa.common.security.annotation.RequiresPermissions;
import com.sfa.common.security.utils.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2024-11-20 15
 * @describe :
 */
@RestController
@RequestMapping("/store/core")
public class EcStoreCoreController {
    @Autowired
    IEcStoreService ecStoreService;

    /**
     * 新增电商-店铺
     */
    @RequiresPermissions("bi:store")
    @Log(title = "电商-店铺", businessType = BusinessType.INSERT)
    @PostMapping
    public void add(@RequestBody @Validated EcStoreVo storeVo)
    {
        EcStoreDto dto = new EcStoreDto();
        BeanUtils.copyProperties(storeVo,dto);
        dto.setCreateBy(SecurityUtils.getUsername());
        dto.setCreateUserId(SecurityUtils.getUserId());
        ecStoreService.addStore(dto);
    }

    /**
     * 修改电商-店铺
     */
    @RequiresPermissions("bi:store")
    @Log(title = "电商-店铺", businessType = BusinessType.UPDATE)
    @PutMapping
    public void edit(@RequestBody @Validated EcStoreVo storeVo)
    {
        EcStoreDto dto = new EcStoreDto();
        BeanUtils.copyProperties(storeVo,dto);
        dto.setUpdateBy(SecurityUtils.getUsername());
        dto.setUpdateUserId(SecurityUtils.getUserId());
        ecStoreService.editStore(dto);
    }

}
