package com.link.bi.domain.mapper;

import com.link.bi.domain.entity.EcMarketDailyDetail;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.link.bi.domain.wq.MarketDetailWq;
import com.link.bi.pojo.response.MarketSummaryDto;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
* @author a02200059
* @description 针对表【ec_market_daily_detail(电商-每日销售明细)】的数据库操作Mapper
* @createDate 2024-11-21 15:21:54
* @Entity com.link.bi.domain.entity.EcMarketDailyDetail
*/
@Repository
@Mapper
public interface EcMarketDailyDetailMapper extends BaseMapper<EcMarketDailyDetail> {

    /**
     *  查询年、月、近7天、昨天数据
     */
    List<MarketSummaryDto> summaryByPlatform(@Param("qw") MarketDetailWq qw);

    List<MarketSummaryDto> chartByPlatform(@Param("qw") MarketDetailWq mqw);
}




