package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.sfa.common.core.annotation.Excel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 电商竞品-生意参谋数据（天猫）对象 oppo_sycm
 *
 * @author admin
 * @date 2024-12-20
 */
@TableName(value = "oppo_sycm")
@Data
public class OppoSycm implements Serializable {
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    /**
     * id标识
     */
    @TableId(type = IdType.AUTO)
    private Long sycmId;

    /**
     * 年份
     */
    @Excel(name = "年份")
    private Long year;

    /**
     * 月份
     */
    @Excel(name = "月份")
    private Long month;

    /**
     * 日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date date;

    /**
     * 平台id-1
     */
    @Excel(name = "平台id-1")
    private Long platformId;

    /**
     * 1 天猫
     */
    @Excel(name = "1 天猫")
    private String platform;

    /**
     * 取数平台：生意参谋
     */
    @Excel(name = "取数平台：生意参谋")
    private String dataPlatform;

    /**
     * 平台店铺
     */
    @Excel(name = "平台店铺")
    private String platformStore;

    /**
     * 商品/货品名称（【百补】洽洽焦糖/五香/山核桃味大包装瓜子500g*2袋恰恰葵花籽）
     */
    @Excel(name = "商品/货品名称", readConverterExp = "【=百补】洽洽焦糖/五香/山核桃味大包装瓜子500g*2袋恰恰葵花籽")
    private String prdName;

    @Excel(name = "商品/货品url，名称会改变，链接地址不会改变")
    private String prdId;
    /**
     * 支付买家数(范围-低)
     */
    @Excel(name = "支付买家数(范围-低)")
    private Long zfmjUnder;

    /**
     * 支付买家数(范围-高)
     */
    @Excel(name = "支付买家数(范围-高)")
    private Long zfmjPeak;

    /**
     * %交易增速(范围-低)
     */
    @Excel(name = "%交易增速(范围-低)")
    private Long jyzsUnder;

    /**
     * %交易增速(范围-高)
     */
    @Excel(name = "%交易增速(范围-高)")
    private Long jyzsPeak;

    /**
     * unique visitor(独立访客范围-低)
     */
    @Excel(name = "unique visitor(独立访客范围-低)")
    private Long uvUnder;

    /**
     * unique visitor(独立访客范围-高)
     */
    @Excel(name = "unique visitor(独立访客范围-高)")
    private Long uvPeak;

    /**
     * %流量增速(范围-低)
     */
    @Excel(name = "%流量增速(范围-低)")
    private Long llzsUnder;

    /**
     * %流量增速(范围-高)
     */
    @Excel(name = "%流量增速(范围-高)")
    private Long llzsPeak;




    /**
     * 支付买家数(范围-低)
     */
    @TableField(exist = false)
    private Long zfmjUnderTotal;

    /**
     * 支付买家数(范围-高)
     */
    @TableField(exist = false)
    private Long zfmjPeakTotal;

    /**
     * %交易增速(范围-低)
     */
    @TableField(exist = false)
    private Long jyzsUnderTotal;

    /**
     * %交易增速(范围-高)
     */
    @TableField(exist = false)
    private Long jyzsPeakTotal;

    /**
     * unique visitor(独立访客范围-低)
     */
    @TableField(exist = false)
    private Long uvUnderTotal;

    /**
     * unique visitor(独立访客范围-高)
     */
    @TableField(exist = false)
    private Long uvPeakTotal;

    /**
     * %流量增速(范围-低)
     */
    @TableField(exist = false)
    private Long llzsUnderTotal;

    /**
     * %流量增速(范围-高)
     */
    @TableField(exist = false)
    private Long llzsPeakTotal;
}
