package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.sfa.common.core.annotation.Excel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 电商竞品-蝉妈妈数据（抖音后台）对象 oppo_cmm
 *
 * @author admin
 * @date 2024-12-19
 */
@TableName(value = "oppo_cmm")
@Data
public class OppoCmm implements Serializable {
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    /**
     * id标识
     */
    @TableId(type = IdType.AUTO)
    private Long cmmId;

    /**
     * 年份
     */
    @Excel(name = "年份")
    private Long year;

    /**
     * 月份
     */
    @Excel(name = "月份")
    private Long month;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date date;

    /**
     * 日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date dateinfo;

    /**
     * 平台id-2
     */
    @Excel(name = "平台id-2")
    private Long platformId;

    /**
     * 2 抖音
     */
    @Excel(name = "2 抖音")
    private String platform;

    /**
     * 取数平台：蝉妈妈
     */
    @Excel(name = "取数平台：蝉妈妈")
    private String dataPlatform;

    /**
     * 店铺名
     */
    @Excel(name = "店铺名")
    private String name;

    /**
     * 直播场次
     */
    @Excel(name = "直播场次")
    private String zbcc;

    /**
     * 观看人次
     */
    @Excel(name = "观看人次")
    private Long gkrcNum;

    /**
     * 观看人次求和
     */
    @Excel(name = "观看人次求和")
    @TableField(exist = false)
    private Long gkrcNumTotal;

    /**
     * 人气峰值
     */
    @Excel(name = "人气峰值")
    private Long rqfz;

    /**
     * unique visitor(独立访客)
     */
    @Excel(name = "unique visitor(独立访客)")
    private Long uv;

    /**
     * 销售量
     */
    @Excel(name = "销售量")
    private BigDecimal saleCount;

    /**
     * 销售额
     */
    @Excel(name = "销售额")
    private BigDecimal saleSum;

    /**
     * 销售额求和
     */
    @Excel(name = "销售额求和")
    @TableField(exist = false)
    private BigDecimal saleSumTotal;
    /**
     * 创建日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date creatDatetime;

}
