package com.link.bi.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.link.bi.domain.dao.IEcGoodsSupplyDemandDao;
import com.link.bi.domain.entity.EcGoodsSupplyDemand;
import com.link.bi.domain.mapper.EcGoodsSupplyDemandMapper;
import com.link.bi.domain.wq.MarketDetailWq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-11-21 16
 * @describe :
 */
@Slf4j
@Service
public class EcGoodsSupplyDemandDaoImpl implements IEcGoodsSupplyDemandDao {

    @Autowired
    EcGoodsSupplyDemandMapper mapper;

    @Override
    public void batchSaveEcGoodsSupplyDemands(List<EcGoodsSupplyDemand> demandList) {
        mapper.batchSaveEcGoodsSupplyDemands(demandList);

    }

    @Override
    public Integer deleteByYear(Integer year) {

        Integer delete = mapper.delete(new LambdaQueryWrapper<EcGoodsSupplyDemand>()
                .eq(EcGoodsSupplyDemand::getYear, year));
        log.info("删除" + delete + "条数据");
        return delete;
    }

    @Override
    public Map<String, Map<String, String>> getSupplyDemandYearAndMonth(MarketDetailWq mqw) {
        QueryWrapper<EcGoodsSupplyDemand> yearWrapper = new QueryWrapper<EcGoodsSupplyDemand>();
        // 年度
        yearWrapper.lambda().eq(EcGoodsSupplyDemand::getYear, mqw.getYear())
                .eq(EcGoodsSupplyDemand::getReportDateType, 1L)
                .isNotNull(EcGoodsSupplyDemand::getPlatformId)
                .groupBy(EcGoodsSupplyDemand::getPlatformId, EcGoodsSupplyDemand::getYear);
        yearWrapper.lambda().select(EcGoodsSupplyDemand::getPlatformId);
        String columns = yearWrapper.getSqlSelect() + ",IFNULL(sum(supply_demand_amount),0) AS supplyDemandCount";
        yearWrapper.select(columns);

        List<Map<String, Object>> yearMaps = mapper.selectMaps(yearWrapper);
        // List转Map<String,Map<String,Object>>
        Map<String, String> yearMap = yearMaps.stream().collect(Collectors.toMap(k -> k.get("platform_id").toString(), v -> ObjectUtil.isNotEmpty(v.get("supplyDemandCount")) ? v.get("supplyDemandCount").toString() : "0"));

        // 月度
        QueryWrapper<EcGoodsSupplyDemand> wrapper = new QueryWrapper<EcGoodsSupplyDemand>();
        wrapper.lambda().eq(EcGoodsSupplyDemand::getYear, mqw.getYear())
                .eq(EcGoodsSupplyDemand::getMonth, mqw.getMonth())
                .eq(EcGoodsSupplyDemand::getReportDateType, 2L)
                .eq(ObjectUtil.isNotEmpty(mqw.getPrdCode()), EcGoodsSupplyDemand::getPrdCode, mqw.getPrdCode())
                .in(ObjectUtil.isNotEmpty(mqw.getPrdCodes()), EcGoodsSupplyDemand::getPrdCode, mqw.getPrdCodes())
                .eq(ObjectUtil.isNotEmpty(mqw.getSeriesId()), EcGoodsSupplyDemand::getSeriesId, mqw.getSeriesId())
                .isNotNull(EcGoodsSupplyDemand::getPlatformId)
                .groupBy(EcGoodsSupplyDemand::getPlatformId, EcGoodsSupplyDemand::getYear, EcGoodsSupplyDemand::getMonth);
        wrapper.lambda().select(EcGoodsSupplyDemand::getPlatformId);
        String monthColumns = yearWrapper.getSqlSelect() + ",IFNULL(sum(supply_demand_amount),0) AS supplyDemandCount";
        wrapper.select(monthColumns);
        // 月度
        List<Map<String, Object>> montMaps = mapper.selectMaps(wrapper);
        Map<String, String> monthMap = montMaps.stream().collect(Collectors.toMap(k -> k.get("platform_id").toString(), v -> ObjectUtil.isNotEmpty(v.get("supplyDemandCount")) ? v.get("supplyDemandCount").toString() : "0"));
        Map<String, Map<String, String>> allMaps = new HashMap<>();
        allMaps.put("year", yearMap);
        allMaps.put("month", monthMap);
        return allMaps;
    }

}
