package com.link.bi.service.impl;


import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.link.bi.config.listener.FinanceBaseZbjTypeListener;
import com.link.bi.domain.dao.IFinanceBaseZbjTypeDao;
import com.link.bi.domain.entity.FinanceBaseZbjType;
import com.link.bi.pojo.request.FinanceBaseZbjTypeListVo;
import com.link.bi.pojo.request.FinanceSelectCommonVo;
import com.link.bi.pojo.response.FinanceBaseZbjTypeImportDto;
import com.link.bi.pojo.response.FinanceZbjTypeListDto;
import com.link.bi.service.FinanceBaseZbjTypeService;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.page.TableSupport;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 旺店通订单Service业务层处理
 *
 * @author lvbencai
 * @date 2025年01月07日17:00:16
 */
//@DS("bi")
@Service
@Slf4j
public class FinanceBaseZbjTypeServiceImpl implements FinanceBaseZbjTypeService {
    @Autowired
    private IFinanceBaseZbjTypeDao dao;
    @Override
    public Map<String, String> selectBaseZbjType() {
        List<FinanceBaseZbjType> list = dao.list(new LambdaQueryWrapper<>());
        // 以fenxiaoName为key，直播间渠道类型为value，放入map中
        Map<String, String> map = list.stream()
                .collect(HashMap::new, (k, v) -> k.put(v.getFenxiaoName(), v.getZbjQdType()), HashMap::putAll);
        return map;
    }

    /**
     * 分页查询
     *
     * @param keyword
     * @return
     */
    @Override
    public IPage<FinanceZbjTypeListDto> pageFinanceBaseZbjType(String keyword) {
        QueryWrapper<FinanceBaseZbjType> queryWrapper = new QueryWrapper<>();
        if (keyword != null && !keyword.isEmpty()) {
            queryWrapper.like("zbj_qd_type", keyword);
        }
        Page<FinanceBaseZbjType> page = dao.page(TableSupport.pageI(), queryWrapper);
        Page<FinanceZbjTypeListDto> result = new Page<>();
        BeanUtils.copyProperties(page, result);
        result.setRecords(page.getRecords().stream().map(item -> {
            FinanceZbjTypeListDto dto = new FinanceZbjTypeListDto();
            BeanUtils.copyProperties(item, dto);
            return dto;
        }).collect(Collectors.toList()));
        result.setTotal(page.getTotal());
        result.setPages(page.getPages());
        result.setCurrent(page.getCurrent());
        return result;
    }

    /**
     * 成本分析页面-查询下拉列表数据
     *
     * @param commonVo
     * @return
     */
    @Override
    public List<FinanceZbjTypeListDto> baseZbjTypeList(FinanceSelectCommonVo commonVo) {
        LambdaQueryWrapper<FinanceBaseZbjType> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.select(FinanceBaseZbjType::getZbjQdType);
        queryWrapper.like(commonVo.getKeyword() != null && !commonVo.getKeyword().isEmpty(), FinanceBaseZbjType::getZbjQdType, commonVo.getKeyword());
        queryWrapper.groupBy(FinanceBaseZbjType::getZbjQdType);
        List<FinanceBaseZbjType> list = dao.list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceZbjTypeListDto> result = new ArrayList<>();
        list.forEach(item -> {
            FinanceZbjTypeListDto dto = new FinanceZbjTypeListDto();
            BeanUtils.copyProperties(item, dto);
            result.add(dto);
        });
        return result;
    }

    /**
     * 直播间分类页面-查询列表数据
     *
     * @param zbjTypeListVo
     * @return
     */
    @Override
    public List<FinanceZbjTypeListDto> baseZbjTypeAllList(FinanceBaseZbjTypeListVo zbjTypeListVo) {
        LambdaQueryWrapper<FinanceBaseZbjType> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.like(zbjTypeListVo.getZbjQdType() != null && !zbjTypeListVo.getZbjQdType().isEmpty(), FinanceBaseZbjType::getZbjQdType, zbjTypeListVo.getZbjQdType());
        List<FinanceBaseZbjType> list = dao.list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceZbjTypeListDto> result = new ArrayList<>();
        list.forEach(item -> {
            FinanceZbjTypeListDto dto = new FinanceZbjTypeListDto();
            BeanUtils.copyProperties(item, dto);
            // 如果fenxiaoName为空，设置为- 2025年02月07日10:35:25
            if (ObjectUtil.isEmpty(dto.getFenxiaoName())) {
                dto.setFenxiaoName("-");
            }
            result.add(dto);
        });
        return result;
    }

    /**
     * 执行Excel数据全量同步
     *
     * @param file 上传的Excel文件
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public String importData(MultipartFile file) {

        if (file.isEmpty()) {
            return "文件为空，请选择有效的 Excel 文件上传。";
        }
        try (InputStream inputStream = file.getInputStream()) {
            FinanceBaseZbjTypeListener listener = new FinanceBaseZbjTypeListener();
            EasyExcel.read(inputStream, FinanceBaseZbjTypeImportDto.class, listener).sheet().doRead();
            List<FinanceBaseZbjTypeImportDto> importData = listener.getDataList();
            // 1. 解析Excel文件，将数据转换为FinanceBaseZbjType对象
            List<FinanceBaseZbjType> dataList = importData.stream().map(item -> {
                FinanceBaseZbjType zbjType = new FinanceBaseZbjType();
                BeanUtils.copyProperties(item, zbjType);
                zbjType.setBatchNo(DateUtil.format(new Date(), "yyyyMMddHHmmss"));
                return zbjType;
            }).collect(Collectors.toList());

            // 2. 删除数据库中不存在于Excel的数据
            deleteAbsentProducts(dataList);
            // 4. 批量保存或更新数据
            batchUpsertProducts(dataList);
            return "文件解析并更新数据成功。";
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            return "文件解析失败，请检查文件格式或内容。";
        }


    }

    public void deleteAbsentProducts(List<FinanceBaseZbjType> dataList) {
        Set excelQdTypes = dataList.stream()
                .map(FinanceBaseZbjType::getZbjQdType)
                .collect(Collectors.toSet());
        // 查询数据库中所有数据
        List<FinanceBaseZbjType> allDbRecords = dao.list(new LambdaQueryWrapper<>());
        // 找出数据库中存在但 Excel 中不存在的记录的 fbztId
        List<Long> idsToDelete = new ArrayList<>();
        for (FinanceBaseZbjType dbRecord : allDbRecords) {
            // 判断 是否匹配ZbjQdType
            if (!excelQdTypes.contains(dbRecord.getZbjQdType())) {
                idsToDelete.add(dbRecord.getFbztId());
            }
        }
        // 删除这些记录
        if (!idsToDelete.isEmpty()) {
            dao.removeByIds(idsToDelete);
        }
    }

    public void batchUpsertProducts(List<FinanceBaseZbjType> dataList) {
        // 查询数据库中所有数据
        List<FinanceBaseZbjType> allDbRecords = dao.list(new LambdaQueryWrapper<>());
//         FbztId匹配到的更新，否则进行保存
        List<FinanceBaseZbjType> recordsToSave = new ArrayList<>();
        List<FinanceBaseZbjType> recordsToUpdate = new ArrayList<>();
        dataList.forEach(data -> {
            FinanceBaseZbjType existingRecord = allDbRecords.stream()
                    .filter(record -> checkRecord(record, data))
                    .findFirst()
                    .orElse(null);
            if (existingRecord != null) {
                // 更新
                BeanUtils.copyProperties(data, existingRecord);
                recordsToUpdate.add(existingRecord);
            } else {
                // 保存
                recordsToSave.add(data);
            }
        });
        // 批量保存
        if (!recordsToSave.isEmpty()) {
            dao.saveBatch(recordsToSave);
        }
        // 批量更新
        if (!recordsToUpdate.isEmpty()) {
            dao.updateBatchById(recordsToUpdate);
        }
//        dao.saveOrUpdateBatch(dataList);
    }

    private boolean checkRecord(FinanceBaseZbjType record, FinanceBaseZbjType data) {
        if (ObjectUtil.isNotEmpty(record.getFenxiaoName())) {
            return record.getFenxiaoName().equals(data.getFenxiaoName())
                    && record.getZbjQdType().equals(data.getZbjQdType());
        } else {
            return ObjectUtil.isEmpty(data.getFenxiaoName()) && record.getZbjQdType().equals(data.getZbjQdType());
        }
    }


}
