package com.link.bi.service.impl;

import com.link.bi.domain.dao.IProductDao;
import com.link.bi.domain.wq.ProductWq;
import com.link.bi.pojo.request.ProductVo;
import com.link.bi.service.IProductService;
import com.sfa.common.core.web.domain.PageInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-11-22 16
 * @describe :
 */
@Service
public class ProductServiceImpl implements IProductService {

    @Autowired
    IProductDao productDao;

    @Override
    public List seriesList() {
        return productDao.selectSeriesList();
    }

    @Override
    public PageInfo productPage(ProductVo productVo) {
        ProductWq qw = new ProductWq();
        BeanUtils.copyProperties(productVo,qw);
        qw.setPrdNameLike(productVo.getPrdName());
        return productDao.productPage(qw);
    }
}
