package com.link.bi.service.impl;

import com.link.bi.service.IFrontVersionCoreService;
import com.sfa.common.redis.service.RedisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author : lvbencai
 * @date : 2025-07-11
 * @describe : 前端版本更新记录service
 */
@Service
public class FrontVersionCoreServiceImpl implements IFrontVersionCoreService {

    @Autowired
    RedisService redisService;


    @Override
    public void addFrontVersion(List<Map> versionList) {
        redisService.deleteObject("frontVersion");
        redisService.setCacheList("frontVersion", versionList);
    }

    @Override
    public void deleteFrontVersion() {
        redisService.deleteObject("frontVersion");
    }


}
