package com.link.bi.service;


import com.link.bi.domain.entity.EcGoodsSupplyDemand;
import com.link.bi.domain.wq.MarketDetailWq;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * 电商-货物供需Service接口
 *
 * @author admin
 * @date 2024-12-05
 */
public interface IEcGoodsSupplyDemandService  {
    List<EcGoodsSupplyDemand> importData(MultipartFile ecGoodsSupplyDemand, Integer year);


    // 批量保存
    void batchSaveEcGoodsSupplyDemands(List<EcGoodsSupplyDemand> demandList);

    void deleteByYear(Integer year);

    Map<String, Map<String, String>> getSupplyDemandYearAndMonth(MarketDetailWq mqw);
}
