package com.link.bi.service.impl;


import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.bi.config.listener.FinanceBaseZbjTypeListener;
import com.link.bi.domain.entity.FinanceBaseZbjType;
import com.link.bi.domain.mapper.FinanceBaseZbjTypeMapper;
import com.link.bi.pojo.request.FinanceBaseZbjTypeListVo;
import com.link.bi.pojo.request.FinanceSelectCommonVo;
import com.link.bi.pojo.response.FinanceZbjTypeListDto;
import com.link.bi.service.FinanceBaseZbjTypeService;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.page.TableSupport;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 旺店通订单Service业务层处理
 *
 * @author lvbencai
 * @date 2025年01月07日17:00:16
 */
@DS("bi")
@Service
public class FinanceBaseZbjTypeServiceImpl extends ServiceImpl<FinanceBaseZbjTypeMapper, FinanceBaseZbjType> implements FinanceBaseZbjTypeService {
    @Override
    public Map<String, String> selectBaseZbjType() {
        List<FinanceBaseZbjType> list = list();
        // 以fenxiaoName为key，直播间渠道类型为value，放入map中
        Map<String, String> map = list.stream()
                .collect(HashMap::new, (k, v) -> k.put(v.getFenxiaoName(), v.getZbjQdType()), HashMap::putAll);
        return map;
    }

    /**
     * 分页查询
     *
     * @param keyword
     * @return
     */
    @Override
    public IPage<FinanceZbjTypeListDto> pageFinanceBaseZbjType(String keyword) {
        QueryWrapper<FinanceBaseZbjType> queryWrapper = new QueryWrapper<>();
        if (keyword != null && !keyword.isEmpty()) {
            queryWrapper.like("zbj_qd_type", keyword);
        }
        Page<FinanceBaseZbjType> page = this.page(TableSupport.pageI(), queryWrapper);
        Page<FinanceZbjTypeListDto> result = new Page<>();
        BeanUtils.copyProperties(page, result);
        result.setRecords(page.getRecords().stream().map(item -> {
            FinanceZbjTypeListDto dto = new FinanceZbjTypeListDto();
            BeanUtils.copyProperties(item, dto);
            return dto;
        }).collect(Collectors.toList()));
        result.setTotal(page.getTotal());
        result.setPages(page.getPages());
        result.setCurrent(page.getCurrent());
        return result;
    }

    /**
     * 成本分析页面-查询下拉列表数据
     * @param commonVo
     * @return
     */
    @Override
    public List<FinanceZbjTypeListDto> baseZbjTypeList(FinanceSelectCommonVo commonVo) {
        LambdaQueryWrapper<FinanceBaseZbjType> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.select(FinanceBaseZbjType::getZbjQdType);
        queryWrapper.like(commonVo.getKeyword() != null && !commonVo.getKeyword().isEmpty(), FinanceBaseZbjType::getZbjQdType, commonVo.getKeyword());
        queryWrapper.groupBy(FinanceBaseZbjType::getZbjQdType);
        List<FinanceBaseZbjType> list = list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceZbjTypeListDto> result = new ArrayList<>();
        list.forEach(item -> {
            FinanceZbjTypeListDto dto = new FinanceZbjTypeListDto();
            BeanUtils.copyProperties(item, dto);
            result.add(dto);
        });
        return result;
    }

    /**
     * 直播间分类页面-查询列表数据
     * @param zbjTypeListVo
     * @return
     */
    @Override
    public List<FinanceZbjTypeListDto> baseZbjTypeAllList(FinanceBaseZbjTypeListVo zbjTypeListVo) {
        LambdaQueryWrapper<FinanceBaseZbjType> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.like(zbjTypeListVo.getZbjQdType() != null && !zbjTypeListVo.getZbjQdType().isEmpty(), FinanceBaseZbjType::getZbjQdType, zbjTypeListVo.getZbjQdType());
        List<FinanceBaseZbjType> list = list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceZbjTypeListDto> result = new ArrayList<>();
        list.forEach(item -> {
            FinanceZbjTypeListDto dto = new FinanceZbjTypeListDto();
            BeanUtils.copyProperties(item, dto);
            // 如果fenxiaoName为空，设置为- 2025年02月07日10:35:25
            if(ObjectUtil.isEmpty(dto.getFenxiaoName())){
                dto.setFenxiaoName("-");
            }
            result.add(dto);
        });
        return result;
    }

    /**
     * 执行Excel数据全量同步
     * @param file 上传的Excel文件
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public String importData(MultipartFile file) {

        if (file.isEmpty()) {
            return "文件为空，请选择有效的 Excel 文件上传。";
        }
        try (InputStream inputStream = file.getInputStream()) {
            FinanceBaseZbjTypeListener listener = new FinanceBaseZbjTypeListener();
            EasyExcel.read(inputStream, FinanceBaseZbjType.class, listener).sheet().doRead();
            List<FinanceBaseZbjType> dataList = listener.getDataList();
            // 3. 删除数据库中不存在于Excel的数据
            deleteAbsentProducts(dataList);
            // 4. 批量保存或更新数据
            batchUpsertProducts(dataList);
            return "文件解析并更新数据成功。";
        } catch (IOException e) {
            e.printStackTrace();
            return "文件解析失败，请检查文件格式或内容。";
        }


    }
    public void deleteAbsentProducts(List<FinanceBaseZbjType> dataList) {
        // 获取 Excel 中所有数据的 fbztId
        List<Long> excelIds = dataList.stream().map(FinanceBaseZbjType::getFbztId).collect(Collectors.toList());
        // 查询数据库中所有数据
        List<FinanceBaseZbjType> allDbRecords = this.list();
        // 找出数据库中存在但 Excel 中不存在的记录的 fbztId
        List<Long> idsToDelete = new ArrayList<>();
        for (FinanceBaseZbjType dbRecord : allDbRecords) {
            if (!excelIds.contains(dbRecord.getFbztId())) {
                idsToDelete.add(dbRecord.getFbztId());
            }
        }
        // 删除这些记录
        if (!idsToDelete.isEmpty()) {
            this.removeByIds(idsToDelete);
        }
    }

    public void batchUpsertProducts(List<FinanceBaseZbjType> dataList) {
        for (FinanceBaseZbjType data : dataList) {
            if (data.getFbztId() != null) {
                // 如果 fbztId 不为空，尝试更新
                UpdateWrapper<FinanceBaseZbjType> updateWrapper = new UpdateWrapper<>();
                updateWrapper.eq("fbzt_id", data.getFbztId());
                this.update(data, updateWrapper);
            } else {
                // 如果 fbztId 为空，进行保存
                this.save(data);
            }
        }
    }




}
