package com.link.bi.controller.query;

import com.link.bi.pojo.request.FinanceBaseZbjTypeListVo;
import com.link.bi.pojo.response.FinanceZbjTypeListDto;
import com.link.bi.service.FinanceBaseZbjTypeService;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 财务分析-直播间分类基础数据
 *
 * @author admin
 * @date 2024-12-19
 */
@RestController
@RequestMapping("/finance/baseZbjType")
public class FinanceBaseZbjTypeController extends BaseController {

    @Autowired
    private FinanceBaseZbjTypeService baseZbjTypeService;
    /**
     * 直播间分类的页面查询
     * @param zbjTypeListVo
     * @return
     */
    @RequiresPermissions("bi:livecate:list")
    @GetMapping("/list")
    public List<FinanceZbjTypeListDto> baseZbjTypeAllList(FinanceBaseZbjTypeListVo zbjTypeListVo) {
        return baseZbjTypeService.baseZbjTypeAllList(zbjTypeListVo);
    }

    @RequiresPermissions("bi:livecate:list")
    @PostMapping("/import")
    public void importData(@RequestParam("file") MultipartFile file) {
          baseZbjTypeService.importData(file);
    }

}
