package com.link.bi.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.link.bi.domain.dao.IOppoSycmStoreDao;
import com.link.bi.domain.entity.OppoSycmStore;
import com.link.bi.domain.wq.OppoSycmWq;
import com.link.bi.pojo.request.OppoSycmVo;
import com.link.bi.pojo.response.OppoSycmStoreDto;
import com.link.bi.pojo.response.OppoSycmStoreInfoDto;
import com.link.bi.service.IOppoSycmStoreService;
import com.sfa.common.core.utils.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 电商竞品-生意参谋竞店数据（天猫）Service业务层处理
 *
 * @author admin
 * @date 2024-12-20
 */
@Service
public class OppoSycmStoreServiceImpl implements IOppoSycmStoreService {

    @Autowired
    IOppoSycmStoreDao sycmStoreDao;

    @Override
    public List<List<OppoSycmStoreDto>> selectOppoSycmStoreBi(OppoSycmVo sycmVo) {
        // 设置默认入参时间，倒数30天
        // Optional判断入参为空设置默认值
        Date startDate = Optional.ofNullable(sycmVo.getStartDate())
                .orElse(DateUtils.addDays(DateUtils.dateStart(new Date()), -31));
        Date endDate = Optional.ofNullable(sycmVo.getEndDate()).orElse(
                DateUtils.addDays(DateUtils.dateStart(new Date()), -1));
        sycmVo.setStartDate(startDate);
        sycmVo.setEndDate(endDate);

        OppoSycmWq wq = new OppoSycmWq();

        BeanUtils.copyProperties(sycmVo, wq);
        // prdId不为空，则prdId转成List
//        if (ObjectUtil.isNotEmpty(sycmVo.getPrdId())) {
//            List<String> prdIds = Arrays.asList(sycmVo.getPrdId().split(","));
//            wq.setPrdIds(prdIds);
//        }
        if (ObjectUtil.isNotEmpty(sycmVo.getPlatformStore())) {
            List<String> platformStores = Arrays.asList(sycmVo.getPlatformStore().split(","));
            wq.setPlatformStores(platformStores);
        }
        List<OppoSycmStore> oppoSycms = sycmStoreDao.selectList(wq);

        List<List<OppoSycmStoreDto>> lists = new ArrayList<>();
        // 按照name分成不同的list
        Map<String, List<OppoSycmStore>> map = oppoSycms.stream()
                .collect(Collectors.groupingBy(OppoSycmStore::getPlatformStore));

        map.forEach((name, objects) -> {
            List<OppoSycmStoreDto> oppoCmmVOS = new ArrayList<>();
            objects.forEach(obj -> {
                OppoSycmStoreDto vo = new OppoSycmStoreDto();
                BeanUtils.copyProperties(obj, vo);
                oppoCmmVOS.add(vo);
            });
            lists.add(oppoCmmVOS);
        });
        return lists;
    }

    @Override
    public List<OppoSycmStoreInfoDto> selectOppoSycmStoreInfoBi() {
        List<OppoSycmStore> oppoSycms = sycmStoreDao.selectOppoSycmStoreInfoBi();
        List<OppoSycmStoreInfoDto>  dtoList = new ArrayList<>();
        oppoSycms.forEach(obj -> {
            OppoSycmStoreInfoDto dto = new OppoSycmStoreInfoDto();
            BeanUtils.copyProperties(obj, dto);
            dtoList.add(dto);
        });
        return dtoList;
    }
}
