package com.link.bi.controller.query;

import com.link.bi.pojo.request.ProductVo;
import com.link.bi.service.IProductService;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-11-22 16
 * @describe :
 */
@RestController
@RequestMapping("/prd/query")
public class PrdQueryController {

    @Autowired
    IProductService productService;

    /**
     * 查询商品系列列表
     */
    @RequiresPermissions("bi:product:list")
    @GetMapping("/series")
    public List seriesList(){
        return productService.seriesList();
    }

    @RequiresPermissions("bi:product:list")
    @GetMapping()
    public PageInfo productPage(ProductVo productVo){
        return productService.productPage(productVo);
    }



}
