package com.link.bi.service.impl;

import com.link.bi.domain.dao.IEcStoreDao;
import com.link.bi.domain.wq.EcStoreWq;
import com.link.bi.pojo.request.EcStoreVo;
import com.link.bi.pojo.response.EcStoreDto;
import com.link.bi.service.IEcStoreService;
import com.sfa.common.core.web.domain.PageInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-11-20 15
 * @describe :
 */
@Service
public class EcStoreServiceImpl implements IEcStoreService {

    @Autowired
    IEcStoreDao ecStoreDao;

    @Override
    public PageInfo selectPage(EcStoreVo ecStoreVo) {
        EcStoreWq wq = new EcStoreWq();
        BeanUtils.copyProperties(ecStoreVo,wq);
        wq.setStoreNameLike(ecStoreVo.getStoreName());

        return ecStoreDao.selectPage(wq);
    }

    @Override
    public void addStore(EcStoreDto dto) {
        ecStoreDao.add(dto);
    }

    @Override
    public void editStore(EcStoreDto dto) {
        ecStoreDao.editStore(dto);
    }
}
