package com.link.bi.domain.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.link.bi.domain.dao.IEcGoodsSupplyDemandDao;
import com.link.bi.domain.entity.EcGoodsSupplyDemand;
import com.link.bi.domain.mapper.EcGoodsSupplyDemandMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-11-21 16
 * @describe :
 */
@Service
public class EcGoodsSupplyDemandDaoImpl implements IEcGoodsSupplyDemandDao {

    @Autowired
    EcGoodsSupplyDemandMapper mapper;

    @Override
    public void batchSaveEcGoodsSupplyDemands(List<EcGoodsSupplyDemand> demandList) {
        mapper.batchSaveEcGoodsSupplyDemands(demandList);

    }

    @Override
    public Integer deleteByYear(Integer year) {

        Integer delete = mapper.delete(new LambdaQueryWrapper<EcGoodsSupplyDemand>()
                .eq(EcGoodsSupplyDemand::getYear, year));
        System.out.println("删除" + delete + "条数据");
        return delete;
    }

}
