package com.link.bi.service.impl;


import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.bi.domain.entity.FinanceBaseZbjType;
import com.link.bi.domain.mapper.FinanceBaseZbjTypeMapper;
import com.link.bi.pojo.request.FinanceSelectCommonVo;
import com.link.bi.pojo.response.FinanceZbjTypeListDto;
import com.link.bi.service.FinanceBaseZbjTypeService;
import com.sfa.common.core.utils.bean.BeanUtils;
import com.sfa.common.core.web.page.TableSupport;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 旺店通订单Service业务层处理
 *
 * @author lvbencai
 * @date 2025年01月07日17:00:16
 */
@DS("bi")
@Service
public class FinanceBaseZbjTypeServiceImpl extends ServiceImpl<FinanceBaseZbjTypeMapper, FinanceBaseZbjType> implements FinanceBaseZbjTypeService {
    @Override
    public Map<String, String> selectBaseZbjType() {
        List<FinanceBaseZbjType> list = list();
        // 以fenxiaoName为key，直播间渠道类型为value，放入map中
        Map<String, String> map = list.stream()
                .collect(HashMap::new, (k, v) -> k.put(v.getFenxiaoName(), v.getZbjQdType()), HashMap::putAll);
        return map;
    }



    /**
     * 分页查询
     *
     * @param keyword
     * @return
     */
    @Override
    public IPage<FinanceZbjTypeListDto> pageFinanceBaseZbjType(String keyword) {
        QueryWrapper<FinanceBaseZbjType> queryWrapper = new QueryWrapper<>();
        if (keyword != null && !keyword.isEmpty()) {
            queryWrapper.like("zbj_qd_type", keyword);
        }
        Page<FinanceBaseZbjType> page = this.page(TableSupport.pageI(), queryWrapper);
        Page<FinanceZbjTypeListDto> result = new Page<>();
        BeanUtils.copyProperties(page, result);
        result.setRecords(page.getRecords().stream().map(item -> {
            FinanceZbjTypeListDto dto = new FinanceZbjTypeListDto();
            BeanUtils.copyProperties(item, dto);
            return dto;
        }).collect(Collectors.toList()));
        result.setTotal(page.getTotal());
        result.setPages(page.getPages());
        result.setCurrent(page.getCurrent());
        return result;
    }

    @Override
    public List<FinanceZbjTypeListDto> baseZbjTypeList(FinanceSelectCommonVo commonVo) {
        LambdaQueryWrapper<FinanceBaseZbjType> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.select(FinanceBaseZbjType::getZbjQdType);
        queryWrapper.like(commonVo.getKeyword() != null && !commonVo.getKeyword().isEmpty(), FinanceBaseZbjType::getZbjQdType, commonVo.getKeyword());
        queryWrapper.groupBy(FinanceBaseZbjType::getZbjQdType);
        List<FinanceBaseZbjType> list = list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceZbjTypeListDto> result = new ArrayList<>();
        list.forEach(item -> {
            FinanceZbjTypeListDto dto = new FinanceZbjTypeListDto();
            BeanUtils.copyProperties(item, dto);
            result.add(dto);
        });
        return result;
    }

    @Override
    public List<FinanceZbjTypeListDto> baseZbjTypeAllList(FinanceSelectCommonVo commonVo) {
        LambdaQueryWrapper<FinanceBaseZbjType> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.like(commonVo.getKeyword() != null && !commonVo.getKeyword().isEmpty(), FinanceBaseZbjType::getZbjQdType, commonVo.getKeyword());
        List<FinanceBaseZbjType> list = list(queryWrapper);

        // 转化成List<FinanceZbjTypeListDto>
        List<FinanceZbjTypeListDto> result = new ArrayList<>();
        list.forEach(item -> {
            FinanceZbjTypeListDto dto = new FinanceZbjTypeListDto();
            BeanUtils.copyProperties(item, dto);
            result.add(dto);
        });
        return result;
    }
}
