package com.link.bi.pojo.response;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 财务订单明细聚合查询DTO
 * @date : 2025-01-15 15:30:05
 * @author : lvbencai
 */
@Data
public class FinanceExportBiListDto {
    // 前端展示用
    @ExcelProperty(value = "唯一值")
    private String uid;

    // 主播渠道类型--来自备注字段
    @ExcelProperty("主播间分类")
    private String zbjQdType;
    // 分销商id
    @ExcelProperty("分销商id")
    private String fenxiaoId;
    // 分销商name
    @ExcelProperty("分销商名称")
    private String fenxiaoName;
    // 货品名称
    @ExcelProperty("商品名称")
    private String goodsName;
    // 货品编号
    @ExcelProperty("商品编号")
    private String goodsNo;
    // ERP规格名称 --来自T100的定义
    @ExcelProperty("规格")
    private String specNameErp;
    // ERP口味 --来自T100的定义
    @ExcelProperty("口味")
    private String flavorErp;
    // 分摊后总价
    @ExcelProperty("分摊后总价")
    private BigDecimal shareAmountSum;
    // 实际成本
    @ExcelProperty("实际成本")
    private BigDecimal actualCostSum;
    // 标准成本
    @ExcelProperty("标准成本")
    private BigDecimal standardCostSum;
    // 实际成本毛利
    @ExcelProperty("实际成本毛利")
    private BigDecimal actualCostGrossProfitSum;
    // 标准成本毛利
    @ExcelProperty("标准成本毛利")
    private BigDecimal standardCostGrossProfitSum;
}
