package com.link.bi.controller.query;

import com.link.bi.pojo.request.PrdTagVo;
import com.link.bi.service.IPrdTagQueryService;
import com.sfa.common.core.web.domain.PageInfo;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-12-04 18
 * @describe :
 */
@RestController
@RequestMapping("/prd_tage/query")
public class PrdTagQueryController {

    @Autowired
    private IPrdTagQueryService prdTagQueryService;

    /**
     * 查询标签
     */
    @RequiresPermissions("bi:prdtag:list")
    @GetMapping("/page")
    public PageInfo queryTags(PrdTagVo prdTagVo) {
        return prdTagQueryService.pageTag(prdTagVo);
    }

    @RequiresPermissions("bi:prdtag:list")
    @GetMapping("/infos")
    public List queryInfo(PrdTagVo prdTagVo){
        if (Objects.isNull(prdTagVo.getPrdTagId())){
            return new ArrayList<>();
        }
        return prdTagQueryService.selectTagInfos(prdTagVo);
    }
}
