package com.link.bi.domain.orderdomain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * T100出货单中的物流单据
 * @TableName orders_sent
 */
@TableName(value ="orders_sent")
@Data
@Accessors(chain = true)
public class OrdersSent implements Serializable {
    /**
     * 发货单自增ID
     */
    @TableId(type = IdType.AUTO)
    private Long sendId;

    /**
     * 安徽单据编号
     */
    private String ahSentNo;

    /**
     * 北京单据编号
     */
    private String bjSentNo;

    /**
     * 版本号
     */
    private Integer bjSentVersion;

    /**
     * X06:销售出库单;N02:杂发单
     */
    private String type;

    /**
     * 过账日期
     */
    private Date postData;

    /**
     * 状态
     */
    private String status;

    /**
     * 运输公司编码
     */
    private String transport;

    /**
     * 运输公司
     */
    private String transportName;

    /**
     * 经销商编码
     */
    private String dealerCode;

    /**
     * 快递单号
     */
    private String expressNo;

    /**
     * DD单号
     */
    private String ddNo;

    /**
     * 0：已推送；1：未推送（推送勤策）
     */
    private Integer pushQc;

    /**
     * 签收时间，为空时代表未签收
     */
    private Date operateEndDatetime;

    /**
     * 物流状态
     */
    private String sentStatus;

    /**
     * 回单状态：有/无/回单异常
     */
    private String receiptFlag;

    /**
     * 回单图片
     */
    private String receiptPhoto;

    /**
     * 回单图片是否完整
     */
    private String receiptPhotoCompleteFlag;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}