package com.link.bi.domain.wq;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-11-21 17
 * @describe :
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class MarketDetailWq {
    /**
     * 年份
     */
    private Integer year;

    /**
     * 月份
     */
    private Integer month;

    /**
     * 指定截止日期，默认昨天
     */
    private Date date;

    /**
     * 货品品类id
     * 带汤去骨、礼盒、虎皮凤爪……
     */
    private Integer seriesId;

    /**
     * 商品/货品编码
     * |礼盒-2025小抓财手|、|虎皮凤爪-香辣400g|、|牛肉豆堡-卤香120g|……
     * */
    private String prdCode;
}
