package com.link.bi.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.link.bi.config.listener.EcGoodsSupplyDemandListener;
import com.link.bi.domain.dao.IEcGoodsSupplyDemandDao;
import com.link.bi.domain.entity.EcGoodsSupplyDemand;
import com.link.bi.domain.mapper.EcGoodsSupplyDemandMapper;
import com.link.bi.domain.wq.MarketDetailWq;
import com.link.bi.pojo.request.EcStoreVo;
import com.link.bi.pojo.response.PrdInfoDto;
import com.link.bi.service.IEcGoodsSupplyDemandService;
import com.link.bi.service.IProductService;
import com.sfa.common.core.web.domain.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 电商-货物供需Service业务层处理
 *
 * @author admin
 * @date 2024-12-05
 */
@Service
@Slf4j
public class EcGoodsSupplyDemandServiceImpl extends ServiceImpl<EcGoodsSupplyDemandMapper, EcGoodsSupplyDemand> implements IEcGoodsSupplyDemandService {
    @Autowired
    IEcGoodsSupplyDemandDao demandDao;

    @Autowired
    IProductService productService;

    /**
     * 导入数据
     * @param multipartFile
     * @param year
     * @return
     */
    @Override
    public List<EcGoodsSupplyDemand> importData(MultipartFile multipartFile, Integer year) {
        // 上传并解析excel
        File file = transferToFile(multipartFile);
        List<String> codeLists = new ArrayList<>();
        List<PrdInfoDto> prdInfoDtos = productService.selectListByCodes(codeLists);

        // 创建EcGoodsSupplyDemandListener实例
        EcGoodsSupplyDemandListener listener = new EcGoodsSupplyDemandListener(this, prdInfoDtos, year);
        // 读取文件内容
        EasyExcel.read(file, listener).ignoreEmptyRow(true)
                .headRowNumber(4).sheet("电商-需求").doRead();
        // 获取读取到的数据
        List<EcGoodsSupplyDemand> data = listener.getDemandList();
        return data;
    }

    /**
     * 文件转File
     * 参考https://blog.csdn.net/qq_42383970/article/details/120201524
     *
     * @param multipartFile
     * @return
     */
    public File transferToFile(MultipartFile multipartFile) {
        // 选择用缓冲区来实现这个转换即使用java 创建的临时文件 使用 MultipartFile.transferto()方法 。
        File file = null;
        try {
            String originalFilename = multipartFile.getOriginalFilename();
            String[] filename = originalFilename.split("\\.");
            file = File.createTempFile(filename[0], filename[1] + ".");
            multipartFile.transferTo(file);
            file.deleteOnExit();
        } catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
        }
        return file;
    }

    /**
     * 批量保存
     */
    @Override
    public void batchSaveEcGoodsSupplyDemands(List<EcGoodsSupplyDemand> demandList) {
        demandDao.batchSaveEcGoodsSupplyDemands(demandList);
    }

    @Override
    public void deleteByYear(Integer year) {
        if (ObjectUtil.isEmpty(year)) {
            year = DateUtil.thisYear();
        }
        demandDao.deleteByYear(year);
    }

    /**
     * bi报表查询
     * @param mqw
     * @return
     */
    @Override
    public Map<String, Map<String, String>> getSupplyDemandYearAndMonth(MarketDetailWq mqw) {
        return demandDao.getSupplyDemandYearAndMonth(mqw);
    }

    @Override
    public PageInfo selectPage(EcStoreVo ecStoreVo) {


        return null;
    }

}
