package com.link.bi.pojo.request;

import cn.hutool.core.date.DateUtil;
import com.sfa.common.core.utils.DateUtils;
import lombok.Data;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-11-21 17
 * @describe :
 */
@Data
public class MarketSummaryVo {

    /**
     * 指定截止日期，默认昨天
     */
    private Date date;

    /**
     * 货品品类id
     * 带汤去骨、礼盒、虎皮凤爪……
     */
    private Integer seriesId;

    /**
     * 商品/货品编码
     * |礼盒-2025小抓财手|、|虎皮凤爪-香辣400g|、|牛肉豆堡-卤香120g|……
     * */
    private String prdCode;

    /**
     * 按日期区间查询
     */
    private Date dateStart;
    private Date dateEnd;

    public boolean isOnlyPlatform() {
        return seriesId == null && prdCode == null;
    }

    public void setDate() {
        this.date = DateUtil.offsetDay(DateUtils.dateStart(new Date()), -1);
        if (dateStart == null || dateEnd == null) {
            int i = DateUtil.dayOfMonth(date);
            this.dateStart = DateUtil.offsetDay(date, i-1);
            this.dateEnd = date;
        }
    }
}
