package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.sfa.common.core.annotation.Excel;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.util.Date;

/**
 * 电商竞品-生意参谋数据（天猫）对象 oppo_sycm
 *
 * @author admin
 * @date 2024-12-20
 */
@TableName(value = "oppo_sycm")
@Data
public class OppoSycm implements Serializable {
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    /**
     * id标识
     */
    private Long sycmId;

    /**
     * 年份
     */
    @Excel(name = "年份")
    private Long year;

    /**
     * 月份
     */
    @Excel(name = "月份")
    private Long month;

    /**
     * 日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date date;

    /**
     * 平台id-1
     */
    @Excel(name = "平台id-1")
    private Long platformId;

    /**
     * 1 天猫
     */
    @Excel(name = "1 天猫")
    private String platform;

    /**
     * 取数平台：生意参谋
     */
    @Excel(name = "取数平台：生意参谋")
    private String dataPlatform;

    /**
     * 平台店铺
     */
    @Excel(name = "平台店铺")
    private String platformStore;

    /**
     * 商品/货品名称（【百补】洽洽焦糖/五香/山核桃味大包装瓜子500g*2袋恰恰葵花籽）
     */
    @Excel(name = "商品/货品名称", readConverterExp = "【=百补】洽洽焦糖/五香/山核桃味大包装瓜子500g*2袋恰恰葵花籽")
    private String prdName;

    /**
     * 支付买家数(范围-低)
     */
    @Excel(name = "支付买家数(范围-低)")
    private Long zfmjUnder;

    /**
     * 支付买家数(范围-高)
     */
    @Excel(name = "支付买家数(范围-高)")
    private Long zfmjPeak;

    /**
     * %交易增速(范围-低)
     */
    @Excel(name = "%交易增速(范围-低)")
    private Long jyzsUnder;

    /**
     * %交易增速(范围-高)
     */
    @Excel(name = "%交易增速(范围-高)")
    private Long jyzsPeak;

    /**
     * unique visitor(独立访客范围-低)
     */
    @Excel(name = "unique visitor(独立访客范围-低)")
    private Long uvUnder;

    /**
     * unique visitor(独立访客范围-高)
     */
    @Excel(name = "unique visitor(独立访客范围-高)")
    private Long uvPeak;

    /**
     * %流量增速(范围-低)
     */
    @Excel(name = "%流量增速(范围-低)")
    private Long llzsUnder;

    /**
     * %流量增速(范围-高)
     */
    @Excel(name = "%流量增速(范围-高)")
    private Long llzsPeak;




    /**
     * 支付买家数(范围-低)
     */
    @TableField(exist = false)
    private Long zfmjUnderTotal;

    /**
     * 支付买家数(范围-高)
     */
    @TableField(exist = false)
    private Long zfmjPeakTotal;

    /**
     * %交易增速(范围-低)
     */
    @TableField(exist = false)
    private Long jyzsUnderTotal;

    /**
     * %交易增速(范围-高)
     */
    @TableField(exist = false)
    private Long jyzsPeakTotal;

    /**
     * unique visitor(独立访客范围-低)
     */
    @TableField(exist = false)
    private Long uvUnderTotal;

    /**
     * unique visitor(独立访客范围-高)
     */
    @TableField(exist = false)
    private Long uvPeakTotal;

    /**
     * %流量增速(范围-低)
     */
    @TableField(exist = false)
    private Long llzsUnderTotal;

    /**
     * %流量增速(范围-高)
     */
    @TableField(exist = false)
    private Long llzsPeakTotal;

    public void setSycmId(Long sycmId) {
        this.sycmId = sycmId;
    }

    public Long getSycmId() {
        return sycmId;
    }

    public void setYear(Long year) {
        this.year = year;
    }

    public Long getYear() {
        return year;
    }

    public void setMonth(Long month) {
        this.month = month;
    }

    public Long getMonth() {
        return month;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return date;
    }

    public void setPlatformId(Long platformId) {
        this.platformId = platformId;
    }

    public Long getPlatformId() {
        return platformId;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return platform;
    }

    public void setDataPlatform(String dataPlatform) {
        this.dataPlatform = dataPlatform;
    }

    public String getDataPlatform() {
        return dataPlatform;
    }

    public void setPlatformStore(String platformStore) {
        this.platformStore = platformStore;
    }

    public String getPlatformStore() {
        return platformStore;
    }

    public void setPrdName(String prdName) {
        this.prdName = prdName;
    }

    public String getPrdName() {
        return prdName;
    }

    public void setZfmjUnder(Long zfmjUnder) {
        this.zfmjUnder = zfmjUnder;
    }

    public Long getZfmjUnder() {
        return zfmjUnder;
    }

    public void setZfmjPeak(Long zfmjPeak) {
        this.zfmjPeak = zfmjPeak;
    }

    public Long getZfmjPeak() {
        return zfmjPeak;
    }

    public void setJyzsUnder(Long jyzsUnder) {
        this.jyzsUnder = jyzsUnder;
    }

    public Long getJyzsUnder() {
        return jyzsUnder;
    }

    public void setJyzsPeak(Long jyzsPeak) {
        this.jyzsPeak = jyzsPeak;
    }

    public Long getJyzsPeak() {
        return jyzsPeak;
    }

    public void setUvUnder(Long uvUnder) {
        this.uvUnder = uvUnder;
    }

    public Long getUvUnder() {
        return uvUnder;
    }

    public void setUvPeak(Long uvPeak) {
        this.uvPeak = uvPeak;
    }

    public Long getUvPeak() {
        return uvPeak;
    }

    public void setLlzsUnder(Long llzsUnder) {
        this.llzsUnder = llzsUnder;
    }

    public Long getLlzsUnder() {
        return llzsUnder;
    }

    public void setLlzsPeak(Long llzsPeak) {
        this.llzsPeak = llzsPeak;
    }

    public Long getLlzsPeak() {
        return llzsPeak;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("sycmId", getSycmId())
                .append("year", getYear())
                .append("month", getMonth())
                .append("date", getDate())
                .append("platformId", getPlatformId())
                .append("platform", getPlatform())
                .append("dataPlatform", getDataPlatform())
                .append("platformStore", getPlatformStore())
                .append("prdName", getPrdName())
                .append("zfmjUnder", getZfmjUnder())
                .append("zfmjPeak", getZfmjPeak())
                .append("jyzsUnder", getJyzsUnder())
                .append("jyzsPeak", getJyzsPeak())
                .append("uvUnder", getUvUnder())
                .append("uvPeak", getUvPeak())
                .append("llzsUnder", getLlzsUnder())
                .append("llzsPeak", getLlzsPeak())
                .toString();
    }
}
