package com.link.bi.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.sfa.common.core.annotation.Excel;
import com.sfa.common.core.web.domain.BaseDo;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 王小卤后台数据对象 ec_ba_store_daily_data
 *
 * @author admin
 * @date 2024-12-19
 */
@TableName(value ="ec_ba_store_daily_data")
@Data
public class EcBaStoreDailyData extends BaseDo
{
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    /** id标识 */
    private Long ebtId;

    /** 年份 */
    @Excel(name = "年份")
    private Long year;

    /** 月份 */
    @Excel(name = "月份")
    private Long month;

    /** 日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date date;

    /** 平台id */
    @Excel(name = "平台id")
    private Long platformId;

    /** 1 天猫; 2 抖音; 3 拼多多; 4 京东; 5 私域; 6 分销; 7 线下; 8 样品; 9 团购; 10 其他; */
    @Excel(name = "1 天猫; 2 抖音; 3 拼多多; 4 京东; 5 私域; 6 分销; 7 线下; 8 样品; 9 团购; 10 其他;")
    private String platform;

    /** 取数平台：生意参谋、拼多多后台、抖音罗盘 */
    @Excel(name = "取数平台：生意参谋、拼多多后台、抖音罗盘")
    private String dataPlatform;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String storeCode;

    /** 店铺名称 */
    @Excel(name = "店铺名称")
    private String storeName;

    /** 成交总额-支付金额 */
    @Excel(name = "成交总额-支付金额")
    private BigDecimal gmv;

    /** 净成交总额-支付金额-退款 */
    @Excel(name = "净成交总额-支付金额-退款")
    private BigDecimal netGmv;

    /** 投资回报率，单位% */
    @Excel(name = "投资回报率，单位%")
    private BigDecimal roi;

    /** 推广花费（包含每日额外平均） */
    @Excel(name = "推广花费", readConverterExp = "包=含每日额外平均")
    private BigDecimal promotionCost;

    /** 推广花费-每日额外平均，淘宝天猫有 */
    @Excel(name = "推广花费-每日额外平均，淘宝天猫有")
    private BigDecimal promotionCostExtra;

    /** 推广产出-推广总交易额 */
    @Excel(name = "推广产出-推广总交易额")
    private BigDecimal promotionOutput;

    /** 浏览量 */
    @Excel(name = "浏览量")
    private Long pv;

    /** 点击人数-unique visitor(访客) */
    @Excel(name = "点击人数-unique visitor(访客)")
    private Long uv;

    /** 成交人数-支付买家 */
    @Excel(name = "成交人数-支付买家")
    private Long transactionsNum;

    /** 成交转化率Conversion Rate-支付转化 */
    @Excel(name = "成交转化率Conversion Rate-支付转化")
    private BigDecimal cvr;

    /** 退款金额 */
    @Excel(name = "退款金额")
    private BigDecimal refundAmount;

    /** 退款率:退款金额/gmv */
    @Excel(name = "退款率:退款金额/gmv")
    private BigDecimal refundRate;

    /** 客单价Average Transaction Value */
    @Excel(name = "客单价Average Transaction Value")
    private BigDecimal atv;

    /** 批次号 */
    @Excel(name = "批次号")
    private String batchNo;

    /** 是否删除标志0未删除1已删除 */
    private String delFlag;

    /** 创建人UserID */
    @Excel(name = "创建人UserID")
    private Long createUserId;

    /** 修改人UserID */
    @Excel(name = "修改人UserID")
    private Long updateUserId;

    public void setEbtId(Long ebtId)
    {
        this.ebtId = ebtId;
    }

    public Long getEbtId()
    {
        return ebtId;
    }
    public void setYear(Long year)
    {
        this.year = year;
    }

    public Long getYear()
    {
        return year;
    }
    public void setMonth(Long month)
    {
        this.month = month;
    }

    public Long getMonth()
    {
        return month;
    }
    public void setDate(Date date)
    {
        this.date = date;
    }

    public Date getDate()
    {
        return date;
    }
    public void setPlatformId(Long platformId)
    {
        this.platformId = platformId;
    }

    public Long getPlatformId()
    {
        return platformId;
    }
    public void setPlatform(String platform)
    {
        this.platform = platform;
    }

    public String getPlatform()
    {
        return platform;
    }
    public void setDataPlatform(String dataPlatform)
    {
        this.dataPlatform = dataPlatform;
    }

    public String getDataPlatform()
    {
        return dataPlatform;
    }
    public void setStoreCode(String storeCode)
    {
        this.storeCode = storeCode;
    }

    public String getStoreCode()
    {
        return storeCode;
    }
    public void setStoreName(String storeName)
    {
        this.storeName = storeName;
    }

    public String getStoreName()
    {
        return storeName;
    }
    public void setGmv(BigDecimal gmv)
    {
        this.gmv = gmv;
    }

    public BigDecimal getGmv()
    {
        return gmv;
    }
    public void setNetGmv(BigDecimal netGmv)
    {
        this.netGmv = netGmv;
    }

    public BigDecimal getNetGmv()
    {
        return netGmv;
    }
    public void setRoi(BigDecimal roi)
    {
        this.roi = roi;
    }

    public BigDecimal getRoi()
    {
        return roi;
    }
    public void setPromotionCost(BigDecimal promotionCost)
    {
        this.promotionCost = promotionCost;
    }

    public BigDecimal getPromotionCost()
    {
        return promotionCost;
    }
    public void setPromotionCostExtra(BigDecimal promotionCostExtra)
    {
        this.promotionCostExtra = promotionCostExtra;
    }

    public BigDecimal getPromotionCostExtra()
    {
        return promotionCostExtra;
    }
    public void setPromotionOutput(BigDecimal promotionOutput)
    {
        this.promotionOutput = promotionOutput;
    }

    public BigDecimal getPromotionOutput()
    {
        return promotionOutput;
    }
    public void setPv(Long pv)
    {
        this.pv = pv;
    }

    public Long getPv()
    {
        return pv;
    }
    public void setUv(Long uv)
    {
        this.uv = uv;
    }

    public Long getUv()
    {
        return uv;
    }
    public void setTransactionsNum(Long transactionsNum)
    {
        this.transactionsNum = transactionsNum;
    }

    public Long getTransactionsNum()
    {
        return transactionsNum;
    }
    public void setCvr(BigDecimal cvr)
    {
        this.cvr = cvr;
    }

    public BigDecimal getCvr()
    {
        return cvr;
    }
    public void setRefundAmount(BigDecimal refundAmount)
    {
        this.refundAmount = refundAmount;
    }

    public BigDecimal getRefundAmount()
    {
        return refundAmount;
    }
    public void setRefundRate(BigDecimal refundRate)
    {
        this.refundRate = refundRate;
    }

    public BigDecimal getRefundRate()
    {
        return refundRate;
    }
    public void setAtv(BigDecimal atv)
    {
        this.atv = atv;
    }

    public BigDecimal getAtv()
    {
        return atv;
    }
    public void setBatchNo(String batchNo)
    {
        this.batchNo = batchNo;
    }

    public String getBatchNo()
    {
        return batchNo;
    }
    public void setDelFlag(String delFlag)
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag()
    {
        return delFlag;
    }
    public void setCreateUserId(Long createUserId)
    {
        this.createUserId = createUserId;
    }

    public Long getCreateUserId()
    {
        return createUserId;
    }
    public void setUpdateUserId(Long updateUserId)
    {
        this.updateUserId = updateUserId;
    }

    public Long getUpdateUserId()
    {
        return updateUserId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("ebtId", getEbtId())
            .append("year", getYear())
            .append("month", getMonth())
            .append("date", getDate())
            .append("platformId", getPlatformId())
            .append("platform", getPlatform())
            .append("dataPlatform", getDataPlatform())
            .append("storeCode", getStoreCode())
            .append("storeName", getStoreName())
            .append("gmv", getGmv())
            .append("netGmv", getNetGmv())
            .append("roi", getRoi())
            .append("promotionCost", getPromotionCost())
            .append("promotionCostExtra", getPromotionCostExtra())
            .append("promotionOutput", getPromotionOutput())
            .append("pv", getPv())
            .append("uv", getUv())
            .append("transactionsNum", getTransactionsNum())
            .append("cvr", getCvr())
            .append("refundAmount", getRefundAmount())
            .append("refundRate", getRefundRate())
            .append("atv", getAtv())
            .append("batchNo", getBatchNo())
            .append("delFlag", getDelFlag())
            .append("createBy", getCreateBy())
            .append("createUserId", getCreateUserId())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateUserId", getUpdateUserId())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
