package com.link.bi.domain.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.link.bi.domain.dao.IOppoSycmDao;
import com.link.bi.domain.entity.OppoSycm;
import com.link.bi.domain.mapper.OppoSycmMapper;
import com.link.bi.domain.wq.OppoSycmWq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : lvbencai
 * @date : 2024-12-20 10:32
 * @describe :
 */
@Service
public class OppoSycmDaoImpl implements IOppoSycmDao {
    @Autowired
    OppoSycmMapper oppoSycmMapper;

    @Override
    public List<OppoSycm> selectList(OppoSycmWq wq) {
        // 查询数据库数据
        QueryWrapper<OppoSycm> wrapper = new QueryWrapper<>();
        wrapper.select("`date`,platform_store,SUM(zfmj_under) AS zfmj_under_total, SUM(zfmj_peak) AS zfmj_peak_total , SUM(jyzs_under) AS jyzs_under_total , SUM(jyzs_peak) AS jyzs_peak_total , SUM(uv_under) AS uv_under_total , SUM(uv_peak) AS uv_peak_total, SUM(llzs_under) AS llzs_under_total, SUM(llzs_peak) AS llzs_peak_total ");
        String storeStr = "三只松鼠旗舰店,良品铺子旗舰店,比比赞旗舰店,百草味官方旗舰店,沃隆旗舰店,每果时光旗舰店,老街口旗舰店,洽洽食品官方旗舰店,好利来官方旗舰店,盐津铺子食品旗舰店,德芙官方旗舰店,蒙都旗舰店,脱骨侠旗舰店,炭食光食品旗舰店,藤桥官方旗舰店,蒙时代旗舰店,周黑鸭食品旗舰店";
        wrapper.in("platform_store",storeStr.split(","));
        wrapper.between(ObjectUtil.isNotEmpty(wq.getStartDate()), "date", wq.getStartDate(), wq.getEndDate());
        wrapper.groupBy("platform_store,`date`");
        wrapper.orderByDesc("`date`");
//
        return oppoSycmMapper.selectList(wrapper);
    }
}
