package com.link.bi.controller.query;

import com.link.bi.pojo.request.OppoCmmDto;
import com.link.bi.pojo.response.OppoCmmVO;
import com.link.bi.service.IOppoCmmService;
import com.sfa.common.core.web.controller.BaseController;
import com.sfa.common.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 电商竞品-蝉妈妈数据（抖音后台）Controller
 *
 * @author admin
 * @date 2024-12-19
 */
@RestController
@RequestMapping("/oppo/cmm")
public class OppoCmmQueryController extends BaseController {
    @Autowired
    private IOppoCmmService oppoCmmService;

    /**
     * 查询电商竞品-蝉妈妈数据（抖音后台）列表
     * zbj 直播间数据
     */
    @RequiresPermissions("bi:cmm:list")
    @GetMapping("/zbj")
    public List<List<OppoCmmVO>> selectOppoCmmZbjBiList(OppoCmmDto oppoCmmDto) {
        return oppoCmmService.selectOppoCmmZbjBiList(oppoCmmDto);
    }

}
